/*
 * File......: GETKEY.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_GETKEY()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Wait for the next keypress
 *  $SYNTAX$
 *      GT_GetKey()
 *  $ARGUMENTS$
 *      None
 *  $RETURNS$
 *      The scan code of the key pressed
 *  $DESCRIPTION$
 *      Flushes the keyboard buffer and waits for a key to be pressed
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_LIB.ch"

FUNCTION GT_GetKey

/****************************************************************************
 Purpose - Clear the type-ahead buffer and get the next key pressed
 Returns - Key value
 Author  - Martin Colloby
 Created - 20/5/91
******************************************************************************
 Parameters - None
 Locals     - None
 Externals  - None
****************************************************************************/

CLEAR TYPEAHEAD

RETURN( INKEY( 0 ) )
*
