/*
 * File......: FSIZE.PRG
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: 13/04/93
 * Revision..: 1.0
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "gt_lib.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      GT_FSIZE()
 *  $CATEGORY$
 *      File I/O
 *  $ONELINER$
 *      Return the size in bytes of a low level file.
 *  $SYNTAX$
 *      GT_FSize(<nFileHandle>) --> nSizeInBytes
 *  $ARGUMENTS$
 *      <nFileHandle> is the handle of a file that has been opened or
 *      created with one of Clipper's low level file functions.
 *  $RETURNS$
 *      The size of the file in bytes.
 *  $DESCRIPTION$
 *      GT_FSize() can be used for finding the size of a file opened with
 *      Clipper's low level file functions.
 *  $EXAMPLES$
 *      // Print the size of a file.
 *
 *      local nFile := fopen("LIFE.42")
 *      ? GT_FSize(nFile)     // Print the size of the file.
 *      fclose(nFile)
 *  $SEEALSO$
 *      GT_FTELL() GT_FLOCATE()
 *  $END$
 */

function GT_FSize(nFileHandle)
local nOldPos := 0,;
      nSize   := -1
if valtype(nFileHandle) == TYPE_NUMERIC
   nOldPos := GT_FTell(nFileHandle)
   nSize   := fseek(nFileHandle,0,FS_END)
   fseek(nFileHandle,nOldPos)
endif
return(nSize)
