/*
 * File......: ENDMONTH.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.1
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *  1.0 Original Release
 *  1.1 - 19/10/93 - Changed calls from CTOD to GT_STOD
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_ENDOFMONTH()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *      Find the last weekday of a month
 *  $SYNTAX$
 *      GT_EndOfMonth( dDate )
 *  $ARGUMENTS$
 *      dDate - Date to be considered
 *  $RETURNS$
 *      The last weekday of the month
 *  $DESCRIPTION$
 *      Calculates the last day of the month, and if that is not a weekday,
 *      rolls back until it finds a weekday.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */
*
FUNCTION GT_EndOfMonth( dDate )

/*****************************************************************************
 Purpose - Find the last weekday of the given month
 Returns - Calculated date
 Author  - Martin Colloby
 Created - 4/9/90
******************************************************************************
 Parameters - dDate      - Date to consider
 Locals     - nDay       - Day of dDate
              nMonth     - Month of dDate
              nYear      - Year of dDate
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

LOCAL dRetDate
LOCAL nDay   := 0
LOCAL nMonth := 0
LOCAL nYear  := 0

IF VALTYPE( dDate ) != "D"
    GT_Warning( "Invalid date type passed to GT_EndOfMonth !" )
    RETURN NIL
ENDIF

* Initialise the date variables
nMonth := MONTH( dDate )
nYear  := YEAR( dDate )

nDay := GT_DaysInMonth( dDate )

* Build up new date
dRetDate := GT_STOD( STR( nYear ) + STR( nMonth ) + STR( nDay ) )

* Return the nearest week date
RETURN( GT_RollFwd( dRetDate ) )
*
