/*
 * File......: ELEVBAR.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_ELEVBAR()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Output an elevator bar on screen
 *  $SYNTAX$
 *      GT_ElevBar( nTop , nBottom , nCol , cNorm , cCurrent , ;
 *                  cColor , nCurrent , nTotal )
 *  $ARGUMENTS$
 *      nTop     - Top row of elevator bar
 *      nBottom  - Bottom row of elevator bar
 *      nCol     - Column for elevator bar
 *      cNorm    - Normal bar character
 *      cCurrent - Highlighted bar character
 *      cColor   - Colour of elevator bar
 *      nCurrent - Current value of bar position
 *      nTotal   - Maximum value of bar position
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Draws a bar from nCol , nTop to nCol , nBottom using the character
 *      cNorm, in the colour cColor.  Then draws character cCurrent at a
 *      position calculated as follows :
 *
 *             ( ( nCurrent  )                                    )
 *      nTop + ( ( --------  ) * ( ( nBottom - 1 ) - ( nTop + 1 ) )
 *             ( ( nElements )                                    )
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_lib.ch"

FUNCTION GT_ElevBar( nTop , nBottom , nCol , cNorm , cCurrent , nColor , nCurrent , nTotal )

/*****************************************************************************
 Purpose - Draw an elevator bar at the side of a lookup/achoice/tbrowse
 Returns - None
 Author  - Martin Colloby
 Created - 20/10/92
******************************************************************************
 Parameters - nTop     - Top line of menu box
              nBottom  - Bottom line of menu box
              nCol     - Column for bar
              cNorm    - Normal bar character ( CHR(177) )
              cCurrent - Position within bar character ( CHR(219) )
              nColor   - Standard color
              nCurrent - Index of current element
              nTotal   - Total number of elements available
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

LOCAL nCursor := SET( _SET_CURSOR , SC_NONE )
LOCAL nRow    := 0

* The position of the bar pointer is calculated as follows :
*        ( ( nCurrent  )                                    )
* nTop + ( ( --------  ) * ( ( nBottom - 1 ) - ( nTop + 1 ) )
*        ( ( nElements )                                    )

GT_ColorSet( nColor )
AEVAL( Array( nBottom - nTop - 1 ) , { |e , n| SETPOS( nTop + 1 + nRow , nCol ) , ;
                                               DISPOUT( cNorm ) , ;
                                               nRow++ } )

* Calculate the current position of the pointer, and draw it
SETPOS( nTop + 1 + ( ( nCurrent / nTotal ) * ( nBottom - nTop - 2 ) ) , nCol )
DISPOUT( cCurrent )

* Reset the cursor
SET( _SET_CURSOR , nCursor )

GT_ColorSet( C_NORMAL )

RETURN NIL
*
