/*
 * File......: DECRYPT.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_DECODE
 *  $CATEGORY$
 *      Security
 *  $ONELINER$
 *      Decode an encoded string
 *  $SYNTAX$
 *      GT_Decode( cString )
 *  $ARGUMENTS$
 *      cString - String to be decoded
 *  $RETURNS$
 *      The tring in a decoded format
 *  $DESCRIPTION$
 *      Uses a decryption algorithm to decode a string that has been encoded
 *      using GT_Encode()
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_lib.ch"

FUNCTION GT_Decode( cString )

/*****************************************************************************
 Purpose - Decode an encoded string
 Returns - Decoded string
 Author  - Gevin Keeley
 Created - 3/3/92
 Edited  - 25/4/92 by Martin Colloby - Tidied up
******************************************************************************
 Parameters - cString - String to decode
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

RETURN( ALLTRIM( GT_Deencrypt( ALLTRIM( cString ) ) ) )
*
STATIC FUNCTION GT_Deencrypt( cString )

/*****************************************************************************
 Purpose - De-encrypt a string
 Returns - De-encrypted string
 Author  - Gevin Keeley
 Created - 3/3/92
 Edited  - 25/4/92 by Martin Colloby - Tidied up
******************************************************************************
 Parameters - cString - String to deencrypt
 Privates   - None
 Locals     - cChar   - Current character
              cRetStr - String to return
              nCount  - Count of characters processed
              nInt    - Integer part of character code
              nLength - Length of cString
              nRem    - Remainder of character code
 Externals  - None
*****************************************************************************/

LOCAL cChar := ""
LOCAL cRetStr := ""
LOCAL nCount := 1
LOCAL nInt := 0
LOCAL nLength := LEN( cString )
LOCAL nRem := 0

DO WHILE nCount <= nLength
    nInt := ASC( SUBSTR( cString , nCount , 1 ) )

    nRem := ASC( SUBSTR( cString , nCount + 1 , 1 ) )

    cChar := CHR( nInt * 17 + nRem )

    IIF( cChar == CHR( 0 ), , cRetStr += cChar )

    nCount += 2
ENDDO

RETURN cRetStr
*
