*  The purpose of this function is to return the path associated with
*  a path\file name combination
*  NOTE This function assumes that there is either a file name at the end
*  of the path, or that the path has a trailing '\'
*
parameter cName
if type('cName') <> 'C'
	return .f.
endif
cName = upper(alltrim(cName))
if '\' $ cName
	cName = left(cName, rat('\', cName))
else
	if substr(cName, 2, 1) == ':'
		cName = left(cName, 2)
	else
		cName = ''
	endif
endif
return cName
