
parameters cMsg , xParam2 , cButtons , cReadOptions , cHelpObj

private nAspectRatio , cTalkStat , nWidth , nBCount , nBWidth , cOptions , ;
		nMaxBWidth , cScratch , cTemp , nHeight , nVPos , nOldRMarg , nOldLMarg , ;
		lLastWrap , nInvAR , wMsg , lVMode , nXCtr , nYCtr , aButtons , ;
		nLastMemWidth , cLastPrt , nHPos , nHSize , nVOffSet , nDefButton , ;
		cLastWin , cHelp , cHelpEdit , cTHelp , cTHelpEdit , cBorder , lAlertMode , ;
		cTitle , nChoice, n


if set('TALK') = 'ON'
	set talk off
	cTalkStat = 'ON'
else
	cTalkStat = 'OFF'
endif

if empty(cHelpObj)
	cHelpObj = 'DIALOG'
endif
cBorder = 'DOUBLE'
cLastWin = wontop()
cTitle = ''
if empty(cLastWin)
	cLastWin = 'SCREEN'
else
	cLastWin = substr(cLastWin , 1 , at(' ' , cLastWin))
endif
cHelp = on('KEY' , 'F1')
cHelpEdit = on('KEY' , 'SHIFT+F1')
push key clear

do case
case 'CALLHELP' $ upper(cHelp)
	cTHelp = 'callHelp with cLastWin, cHelpObj'
	on key label F1 do &cTHelp
	if 'HELPEDIT' $ upper(cHelpEdit)
		cTHelpEdit = 'HelpEdit with cLastWin, cHelpObj'
		on key label SHIFT+f1 do &CTHelpEdit
	endif
otherwise
	if not empty(cHelp)
		on key label F1 &cHelp
	endif
	if not empty(cHelpEdit)
		on key label SHIFT+F1 &cHelpEdit
	endif
endcase


cLastPrt = set('PRINT')
set print off
wMsg = sys(2015)
nAspectRatio = scols() / srows()
nInvAR = 1 / nAspectRatio
nBCount = 0
nMaxBWidth = 1
lVMode    = .f.
nWidth    = 0
nChoice = 0
nDefButton = 1
nOldRMarg = _rmargin
nOldLMarg = _lmargin
_lmargin  = 2
lLastWrap = _wrap
_wrap = .t.
nHSize = 2
nVSize = 1
nVOffSet = 0
nXCtr = scols() / 2
nYCtr = srows() / 2
lAlertMode = .f.
do case
case type('XPARAM2') = 'L'
	lAlertMode = xParam2
case type('XPARAM2') = 'C'
	if left(alltrim(xParam2) , 1) = '!'
		lAlertMode = .t.
		cTitle = substr(xParam2 , 2)
	else
		cTitle = xParam2
	endif
	if cHelpObj == 'DIALOG'
		cHelpObj = strtran(alltrim(cTitle) , ' ' , '_')
	endif
endcase
nLastMemWidth = set('MEMOWIDTH')
declare aButtons[10]

if empty(cReadOptions)
	cReadOptions = ''
else
	cReadOptions = alltrim(cReadOptions)
endif

do case
case type('_DOS') = 'U'
	*  No Action.  This case allows 2.0 to use this procedure also
case _DOS
case _Windows
	cBorder = 'SYSTEM'
	nVSize = 1.75
	nHSize = 2
	nVOffset = .75
case _unix
case _mac
endcase
if empty(cButtons)
	cButtons = '@*HT \!  \<OK  '
else
	if left(cButtons , 1) == ';'
		cButtons = '@*VT ' + substr(cButtons , 2)
	endif
	if left(cButtons , 1) != '@'
		cButtons = '@*HT ' + ltrim(cButtons)
	endif
endif

cOptions = upper(left(cButtons , at(' ' , cButtons) - 1))
cButtons = substr(cButtons , at(' ' , cButtons) + 1)

cScratch = cButtons
* Trim off format commands

if right(cScratch , 1) != ';'
	cScratch = cScratch + ';'
endif

cButtons = ''

do while len(cScratch) > 0
	nBCount = nBCount + 1

	cTemp = substr(cScratch , 1 , at(';' , cScratch))
	cScratch = substr(cScratch , len(cTemp) + 1)

	cTemp = strtran(cTemp , ';')

	if not '\<' $ cTemp
		cTemp = AddHotKey(cTemp)
	endif

	cButtons = cButtons + cTemp + ';'

	cTemp = strtran(cTemp , '\<')
	cTemp = strtran(cTemp , '\?')
	cTemp = strtran(cTemp , '\\')
	if '\!' $ cTemp
		nDefButton = nBCount
		cTemp = strtran(cTemp , '\!')
	endif

	aButtons[nBCount] = upper(alltrim(cTemp))

	nBWidth = len(cTemp) + 4
	nMaxBWidth = max(nMaxBWidth , nBWidth)
enddo

nBWidth = (nHSize + nMaxBWidth) * nBCount
cButtons = left(cButtons , len(cButtons) - 1)

* SET ALT HOT KEYS FOR BUTTONS

cTempButt = cButtons
nIndex = at('\<' , cTempButt)
do while nIndex > 0
	cKey = upper(substr(cTempButt , nIndex+2 , 1))
	if ! empty(cKey)
		on key label Alt+&cKey. keyboard "{&cKey}"
	endif
	if nIndex + 2 < len(cTempButt)
		cTempButt = substr(cTempButt , nIndex + 2)
		nIndex = at('\<' , cTempButt)
	else
		nIndex = 0
	endif
enddo

*  Ok, now we need to go through and count the number of buttons
*  and get the widest one., and calc the width of our button line

nWidth = nBWidth + 2

if nWidth + 4 > scols()
	if 'H' $ cOptions
		cOptions = strtran(cOptions , 'H' , 'V')
	else
		if not 'V' $ cOptions
			cOptions = cOptions + 'V'
		endif
	endif
endif

if 'V' $ cOptions
	lVMode = .t.
	nHSize = 1
endif

* cMsg really holds the message we wish to display
cMsg = strtran(cMsg , '~' , chr(13) + chr(10))

if lVMode
	nWidth = 24
	set memowidth to nWidth - 4
	nHeight = nBCount * nVSize * 2
	do while memlines(cMsg) + 1 > nHeight
		nHeight = (nWidth + nMaxBWidth) * nInvAR
		nWidth = nWidth + 4
		set memowidth to nWidth - 4
	enddo

	_rmargin = _lmargin + nWidth - 4
	nWidth = nWidth + nMaxBWidth + 4
	nHeight = nHeight + 2.5
else
	*
	* At this point, nWidth has the width of our buttons	
	*
	n=strlen(cMsg)+6
	do case
	case n > (scols()-20)
		nWidth=Max(nWidth,40)
	case nWidth > n
		nWidth=Max(nWidth,40)
	otherwise
		nWidth=max(nWidth,n)
	endcase
	set memowidth to nWidth - 4
	do while ((nWidth - 4) / (memlines(cMsg) + 5)) < (nAspectRatio)
		nWidth = nWidth + 4
		set memowidth to nWidth - 4
	enddo
	nHeight = memlines(cMsg) + 5
	_rmargin = _lmargin + nWidth - 4
endif



define window (wMsg) ;
		from nYCtr - nHeight / 2 , nXCtr - nWidth / 2 ;
		to nYCtr + nHeight / 2 , nXCtr + nWidth / 2 ;
		color scheme (iif(lAlertMode , 7 , 5)) ;
		shadow float &cBorder title cTitle noclose nogrow nozoom

activate window (wMsg) noshow
if memlines(cMsg) == 1
	?padc(cMsg , (_rmargin - _lmargin) )
else
	? cMsg
endif

if lVMode
	nVPos = (nHeight - nVSize * 2 * nBCount) / 2 + nVOffset
	nHPos = wcols() - 2 - nMaxBWidth
else
	nVPos = row() + 2
	nHPos =  ((wcols() - nBWidth) / 2) + iif(nBCount > 1 , 1 , 2)
endif

clear typeahead
keyboard chr(32)
= inkey()
clear typeahead
wait clear
cButtons = cOptions + ' ' + cButtons

@ nVPos , nHPos get nChoice ;
		picture (cButtons) ;
		size nVSize , nMaxBWidth , nHSize

read cycle ;
		modal ;
		with (wMsg) ;
		object (nDefButton) ;
		&cReadOptions


set memowidth to nLastMemWidth
deactivate window (wMsg)
release window (wMsg)
_rmargin = nOldRMarg
_lmargin = nOldLMarg
_wrap = lLastWrap

if cTalkStat = 'ON'
	set talk on
endif

if cLastPrt = 'ON'
	set print on
endif

pop key

if nChoice > 0
	return aButtons[nChoice]
endif
return ''

function AddHotKey

	parameter cButton
	private n , c

	for n = 1 to len(cButton)
		c = substr(cButton , n , 1)
		if isalpha(c) or isdigit(c)
			cButton = substr(cButton , 1 , n - 1) + ;
					'\<' + substr(cButton , n)
			exit
		endif
	endfor

return cButton

FUNCTION strlen
Parameter c
private n, nLength, nChar
nLength=0
for n=1 to len(c)
	nChar=asc(substr(c,n,1))
	do case
	case nChar=9
		nLength=nLength+8
	case nChar=10 or nChar=12 or nChar=13
		nLength=nLength+255
	otherwise
		nLength=nLength+1
	endcase
endfor
return nLength