/*
  UDEM01.PRG
  Submitted by David L. Smith
               CIS: 72351,225

  ADPushMenu() is a variation of ADBoxMenu() that uses
  the Horizontal PushButton Engine instead of the boxed
  prompt areas.

  Syntax:

  ADPushmenu( <aPrompt>, <aButtons>, [aTrigger], [cColor], ;
              [nTop], [nLeft] )  --> <nSelection>

  <aPrompt> is the prompt string array.  ( {"Drive A: Not Ready"} )
  Prompts of two or more lines are possible by passing an array of 
  strings.

  <aButtons> is an array of option buttons.  ({ "Retry", "Abort" })

  [aTrigger] is an optional array of the index positions of the
  trigger characters.  Defaults to an array of ONEs.

  [cColor] is a color string for the box color, defaults to "GR+/RB"

  [nTop] and [nLeft] are the top/left coordinates of the box.  If not
  passed, the box is centered on the screen.

  <nSelection> is the numeric return value.  It is the index position
  of the selected option.  It is zero if the menu was aborted.
	

   Uses:

	The ubiquituous Default for those that don't have one already:
    #command DEFAULT <idvar> TO <idvalue> ;
     => ;
     <idvar> := IIF( <idvar> == NIL , <idvalue> , <idvar> )

*/


#include "common.ch"
#include "setcurs.ch"


//-----------
func udemo01()
// Call the default Push Menu
? ADpushmenu( )

// Modify the prompts, buttons, triggers, color, and coords 
? ADpushmenu({"Report Destination ?"} , ;		  // prompts
             { "Printer","File ","Abort"} , ;	  // buttons
             { 2, 2, 2 } , ;					  // triggers
             "W+/B" , ;							  // color
             10 , 10 )							  // Top, Left
return NIL


//--------------------------------------------------------
FUNCTION ADPushMenu(aPrompts,aButtons,aTriggers,cCol,nTop,nLeft)
LOCAL nEngine,aScn,cBackGrnd,nButtonlen,nRetVal:=0
LOCAL nHeight,nWidth
LOCAL nCurs:=SETCURSOR(SC_NONE)
LOCAL nRow:=ROW(),nCol:=COL()

// Check Parameters and Assign defaults
DEFAULT aPrompts TO {"Push a Button"}
DEFAULT aButtons TO {"Accept","Cancel"}
DEFAULT aTriggers TO AFILL(ARRAY(Len(aButtons)),1)
DEFAULT cCol TO "GR+/RB"

//Set the background Color for the shadow button
cBackgrnd:=RIGHT(cCol,LEN(cCol)-RAT("/",cCol))

//Calc length of buttons with interspacing
nButtonlen:=LEN(ADarr2str(aButtons,""))+(3*(LEN(aButtons)-1))

//Calc width of box by comparing longer of Buttons or Text
nWidth:=IIF(nButtonlen > ADaMaxlen(aPrompts),nButtonlen,ADaMaxlen(aPrompts))+8

// Set box height
nHeight := LEN(aPrompts)+3

// Default the box corner coords
DEFAULT nLeft TO ADscn_hcenter( nWidth )
DEFAULT nTop TO ADscn_vcenter( nHeight )

//Create button engine
nEngine := ADpb_horizontal( nTop + nHeight , ;
                            nLeft + nWidth/2 - nButtonlen/2 , ;
                            aButtons, ;
                            aTriggers )

//Increment the top line counter before painting the prompts
nTop++

// Buffer all the screen painting
DISPBEGIN()
Ascn:=ADbox( nTop, nLeft, nTop + nHeight + 1, nLeft + nWidth + 1 , cCol)
AEVAL(aPrompts,{|e| ADcsay(++nTop,nLeft,nLeft+nWidth+1,e,cCol)} )
adpb_show(nEngine,cBackgrnd)
DISPEND()

//Wait for user selection
nRetVal:=adpb_activate(nEngine)

//Cleanup and return
IF nRetVal > 0      // made a selection
    ADpb_push( nEngine, nRetval )
ENDIF
ADpb_kill(nEngine)
ADRestscn(aScn)
SETCURSOR(nCurs)
SetPos(nRow,nCol)
RETURN nRetVal

