/*
   TOURS.PRG
   Copyright (c) Angelito Dizon, 1994.  All rights reserved.
*/


#include "inkey.ch"
#include "f_tour.ch"

static bSFConfig := {|| ADfv_prompt( "Print/RunDemo" ), ADfv_linelength(120)}

//--------------------------
func Xboxmenu( nTop, nLeft )
local cPrg, bDemo, cSel
local aMenu := {;
                    "1 Basic Implementation",;
                    "2 Change Its Most Basic Attributes",;
                    "3 How About Cascading Menus?",;
                    "4 Hot Keys",;
                    "5 Hot Spots",;
                    "6 Printer Not Ready",;
                    "7 Which Drive?",;
                    "8 Floppy Not Ready",;
                    "9 Multi-line Prompt",;
                    "0 Generic Switch",;
                    "A Which Floppy Drive?";
               }
local bProcess := {|n| cSel := padl( ADn2s( n ), 2, "0" ),;
                       cPrg := ".\sample\bm_dem" + cSel + ".prg",;
                       bDemo := &( "{||bm_demo" + cSel + "()}" ),;
                       ADfview( cPrg, {||Xprintrun( cPrg, bDemo )}, bSFConfig, "SHOWFILE" );
                  }
ADvermenu( nTop, nLeft, aMenu,, bProcess )
return nil



//-------------------------
func Xdbview( nTop, nLeft )
local cPrg, bDemo, cSel
local aMenu := {;
                    "1 The Basic Implementation",;
                    "2 Change the DB and the Memoedit Attributes",;
                    "3 Add a Title Line Under the DB Box",;
                    "4 Drag the DB Box with the Arrow Keys",;
                    "5 Drag the DB Box with the Mouse",;
                    "6 Add a Horizontal Scroll Bar",;
                    "7 Add a Vertical Scroll Bar",;
                    "8 Ask for Confirmation Before Exiting",;
                    "9 Edit the Current Cell When the Enter Key is Pressed",;
                    "0 Attach Typical Edit/Add/Delete/Recall/Pack Features",;
                    "A Include a Selected Set of Columns Only",;
                    "B Hot-key the +/- Keys to Inc/Dec Numerics and Dates",;
                    "C Hide and Unhide a Browse",;
                    "D View Child Databases",;
                    "E Calculated Column",;
                    "F User-defined Column Headings",;
                    "G Browse a Subset",;
                    "H Do a Seek",;
                    "I Do a SoftSeek",;
                    "J Manipulate Columns",;
                    "K PICTURE, WHEN, VALID Functionalities",;
                    "L Carousel of Browsers",;
                    "M Nested Browses"; 
               }
local bProcess := {|n| cSel := padl( ADn2s( n ), 2, "0" ),;
                       cPrg := ".\sample\db_dem" + cSel + ".prg",;
                       bDemo := &( "{||db_demo" + cSel + "()}" ),;
                       ADfview( cPrg, {||Xprintrun( cPrg, bDemo )}, bSFConfig, "SHOWFILE" );
                  }
ADvermenu( nTop, nLeft, aMenu,, bProcess, {||ADvm_extra( ,{||ADvm_versbar()} )}, "TYPICAL" )
return nil


//--------------------------
func Xshowfile( nTop, nLeft )
local cPrg, bDemo, cSel
local aMenu := {;
                    "Basic Implementation",;
                    "Demo: APIs in Action",;
                    "View a Memo",;
                    "Change the Footer Prompts";
               }
local bProcess := {|n| cSel := padl( ADn2s( n ), 2, "0" ),;
                       cPrg := ".\sample\fv_dem" + cSel + ".prg",;
                       bDemo := &( "{||fv_demo" + cSel + "()}" ),;
                       ADfview( cPrg, {||Xprintrun( cPrg, bDemo )}, bSFConfig, "SHOWFILE" );
                  }
ADvermenu( nTop, nLeft, aMenu,, bProcess )
return nil


//-------------------------
func Xboxedgets( nTop, nLeft )
local cPrg, bDemo, cSel
local aMenu := {;
                    "Basic Demo",;
                    "Add Labels to the Gets",;
                    "Change Default Colors and Location",;
                    "Add When and Valid Clauses",;
                    "Do Some Extra Work",;
                    "Add Push Buttons",;
                    "Edit a Database";
               }
local aTrigger := { 1,5,16,5,9,5 }
local bProcess := {|n| cSel := padl( ADn2s( n ), 2, "0" ),;
                       cPrg := ".\sample\gm_dem" + cSel + ".prg",;
                       bDemo := &( "{||gm_demo" + cSel + "()}" ),;
                       ADfview( cPrg, {||Xprintrun( cPrg, bDemo )}, bSFConfig, "SHOWFILE" );
                  }

ADvermenu( nTop, nLeft, aMenu, aTrigger, bProcess,, "TYPICAL" )
return nil


//--------------------------
func Xhormenu( nTop, nLeft )
local cPrg, bDemo, cSel
local aMenu := {;
                    "Basic Implementation",;
                    "Option-Dependent Procedures",;
                    "PullDown Menus Implementation",;
                    "Looks Configuration";
               }
local bProcess := {|n| cSel := padl( ADn2s( n ), 2, "0" ),;
                       cPrg := ".\sample\hm_dem" + cSel + ".prg",;
                       bDemo := &( "{||hm_demo" + cSel + "()}" ),;
                       ADfview( cPrg, {||Xprintrun( cPrg, bDemo )}, bSFConfig, "SHOWFILE" );
                  }

ADvermenu( nTop, nLeft, aMenu,, bProcess )
return nil

//-------------------------------
func XhelpFacility( nTop, nLeft )
local cPrg, bDemo, cSel
local aMenu := {;
                    "Index the Help File",;
                    "A Simple ADhelp() Call",;
                    "User-Defined Help Screen Header",;
                    "Multi-Level Help Screens";
               }
local bProcess := {|n| cSel := padl( ADn2s( n ), 2, "0" ),;
                       cPrg := ".\sample\hp_dem" + cSel + ".prg",;
                       bDemo := &( "{||hp_demo" + cSel + "()}" ),;
                       ADfview( cPrg, {||Xprintrun( cPrg, bDemo )}, bSFConfig, "SHOWFILE" );
                  }
ADvermenu( nTop, nLeft, aMenu,, bProcess )
return nil


//-------------------------
func Xpushbutton( nTop, nLeft )
local cPrg, bDemo, cSel, aScn
local aMenu := {;
                    "Basic Demo",;
                    "Alt-Key-Combination as Trigger Key",;
                    "Configure the Colors",;
                    "Horizontal Buttons",;
                    "Vertical Buttons",;
                    "Buttonized Database Browser",;
                    "Shadowed Buttons";
               }
local aTrigger := { 1,1,1,1,1,1,8 }
local bProcess := {|n| cSel := padl( ADn2s( n ), 2, "0" ),;
                       cPrg := ".\sample\pb_dem" + cSel + ".prg",;
                       bDemo := &( "{||aScn := ADsavescn(), ADcls(), pb_demo" + cSel + "(), ADrestscn( aScn )}" ),;
                       ADfview( cPrg, {||Xprintrun( cPrg, bDemo )}, bSFConfig, "SHOWFILE" );
                  }

ADvermenu( nTop, nLeft, aMenu, aTrigger, bProcess,, "TYPICAL" )
return nil


//-------------------------
func Xradiobutton( nTop, nLeft )
local cPrg, bDemo, cSel, aScn
local aMenu := {;
                    "Basic Demo",;
                    "Configure the OK Push Button",;
                    "Check Box",;
                    "Preserve the Check Box Toggle Settings";
               }
local aTrigger := { 1,15,1,1 }
local bProcess := {|n| cSel := padl( ADn2s( n ), 2, "0" ),;
                       cPrg := ".\sample\rb_dem" + cSel + ".prg",;
                       bDemo := &( "{||aScn := ADsavescn(), ADcls(), rb_demo" + cSel + "(), ADrestscn( aScn )}" ),;
                       ADfview( cPrg, {||Xprintrun( cPrg, bDemo )}, bSFConfig, "SHOWFILE" );
                  }

ADvermenu( nTop, nLeft, aMenu, aTrigger, bProcess,, "TYPICAL" )
return nil



//-----------------------
func Xread( nTop, nLeft )
local cPrg, bDemo, cSel, aScn
local aMenu := {;
                    "1 Basic Implementation",;
                    "2 User-defined Initial Focus",;
                    "3 Reactivating an Exited Read",;
                    "4 Hot Keys, Jump to any Get, Blank a Get",;
                    "5 Hot Spots, Blank All Gets",;
                    "6 Popup Picklist, Required Get",;
                    "7 Wrap Around the Gets",;
                    "8 Time Out Feature",;
                    "9 Read-wise Validation",;
                    "0 Key-wise Validation",;
                    "A One-Get Read",;
                    "B Calculator-Style Reader",;
                    "C Jump Keys",;
                    "D Help ID for Each Get",;
                    "E Generic Boxed Get/Read",;
                    "F Generic Boxed Get/Read - Configured",;
                    "G Nested Reads Via Hot Key",;
                    "H Nested Reads Via Valid Clause",;
                    "I Popup Database Browse";
               }
local bProcess := {|n| cSel := padl( ADn2s( n ), 2, "0" ),;
                       cPrg := ".\sample\rd_dem" + cSel + ".prg",;
                       bDemo := &( "{||aScn := ADsavescn(), ADcls(), rd_demo" + cSel + "(), ADrestscn( aScn )}" ),;
                       ADfview( cPrg, {||Xprintrun( cPrg, bDemo )}, bSFConfig, "SHOWFILE" );
                  }
ADvermenu( nTop, nLeft, aMenu,, bProcess, {||ADvm_extra( ,{||ADvm_versbar()} )}, "TYPICAL" )
return nil



//-----------------------------
func Xscrollbar( nTop, nLeft )
local cPrg, bDemo, cSel
local aMenu := {;
                    "Basic Implementation",;
                    "Reconfigure the Scroll Characters",;
                    "Reconfigure the Colors";
               }
local bProcess := {|n| cSel := padl( ADn2s( n ), 2, "0" ),;
                       cPrg := ".\sample\sb_dem" + cSel + ".prg",;
                       bDemo := &( "{||sb_demo" + cSel + "()}" ),;
                       ADfview( cPrg, {||Xprintrun( cPrg, bDemo )}, bSFConfig, "SHOWFILE" );
                  }

ADvermenu( nTop, nLeft, aMenu, {1,17,17}, bProcess )
return nil



//--------------------------
func Xvermenu( nTop, nLeft )
local cPrg, bDemo, cSel, aScn
local aMenu := {;
                    "1 Demo: The Basic Implementation",;
                    "2 Add A Header",;
                    "3 Scrolling Picklist With Scrollbar",;
                    "4 Mark the Current Selection With an Arrow",;
                    "5 Display Option-Sensitive Messages",;
                    "6 Taglist",;
                    "7 Restricted Taglist",;
                    "8 User-Defined Hot Keys",;
                    "9 User-Defined Hot Spots",;
                    "0 Cascading (Nested) Menus",;
                    "A Change the Default Color and Box Attributes",;
                    "B Group and Inactivate Options",;
                    "C Time Out",;
                    "D Tag All, Clear Tags, Reverse Tags",;
                    "E Basic Drives Picklist",;
                    "F Enhanced Drives Picklist",;
                    "G Basic Directories Picklist",;
                    "H Enhanced Directories Picklist",;
                    "I Basic Files Picklist",;
                    "J Enhanced Files Picklist",;
                    "K Fields Taglist",;
                    "L Database Browser Column Headings Picklist";
               }
local bProcess := {|n| cSel := padl( ADn2s( n ), 2, "0" ),;
                       cPrg := ".\sample\vm_dem" + cSel + ".prg",;
                       bDemo := &( "{||aScn := ADsavescn(), ADcls(), vm_demo" + cSel + "(), ADrestscn( aScn )}" ),;
                       ADfview( cPrg, {||Xprintrun( cPrg, bDemo )}, bSFConfig, "SHOWFILE" );
                  }

ADvermenu( nTop, nLeft, aMenu,, bProcess, {||ADvm_extra( ,{||ADvm_versbar()} )}, "TYPICAL" )
return nil


//---------------------------
func Xnewdemos( nTop, nLeft )
local cPrg, bDemo, cSel
local aMenu := {;
                    "1 (2.1) Browse/Edit a Dbf With a Calculated Numeric Field",;
                    "2 (2.1) Browse with Push Button & Boxed/Gets Engines",;
                    "3 (2.1) Inactivate Push Buttons and Change Their Colors",;
                    "4 (2.2) New ADdbview() Color Configuration",;
                    "5 (2.2) Toggle ADhormenu() Options and Option-Sensitive Help",;
                    "6 (2.2) ADwait() extensions",;
                    "7 (2.2) The Frankie Development Tools",;
                    "8 (2.2) Browse with Push Buttons";
               }
local bProcess := {|n| cSel := padl( ADn2s( n + 2 ), 2, "0" ),;
                       cPrg := ".\newdemo\fdem" + cSel + ".prg",;
                       bDemo := &( "{||fdemo" + cSel + "()}" ),;
                       ADfview( cPrg, {||Xprintrun( cPrg, bDemo )}, bSFConfig, "SHOWFILE" );
                  }
ADvermenu( nTop, nLeft, aMenu,, bProcess )
return NIL


//---------------------------
func Xuserdemos( nTop, nLeft )
local cPrg, bDemo, cSel, aScn
local aMenu := {;
                    "1 Dialog Box with Push Buttons",;
                    "2 File Manager",;
                    "3 Detecting Mouse Double Clicks",;
                    "4 Personal Address Manager";
               }
local bProcess := {|n| cSel := padl( ADn2s( n ), 2, "0" ),;
                       cPrg := ".\userdemo\udem" + cSel + ".prg",;
                       bDemo := &( "{||aScn := ADsavescn(), ADcls(), udemo" + cSel + "(), ADrestscn( aScn )}" ),;
                       ADfview( cPrg, {||Xprintrun( cPrg, bDemo )}, bSFConfig, "SHOWFILE" );
                  }
ADvermenu( nTop, nLeft, aMenu,, bProcess )
return NIL
