/*
    HM_DEM04.PRG
    Copyright (c) The Programmer's Desk, 1992-94.  All rights reserved.

    Demonstration of a reconfigured pulldown menu.  This is the same as
    HM_DEMO3.PRG, except that the colors and location of the horizontal
    menu is reconfigured via the following APIs:

    ADhm_row() - specifies the row position of the menu

    ADhm_ends() - specifies the column positions of the ends of the menu
*/


// Uncomment the following line if you are using Clipper 5.01.
// #include "f2_501.ch"

//--------------
func hm_demo04()
local aScn
local aMenu := { "Databases", "Utilities", "Quit" }
local bDispBegin := {|| ADhm_colors( { "N/W*",;
                                       "GR+/R",;
                                       "BG+" };
                                   ),;
                        aScn := ADbox( 4,4,20,49,;
                                       ADhm_colors()[1] ),;                 
                        ADsay( 6,4,;
                                "" + repl( "", 44 ) + "",;
                                ADhm_colors()[1];
                              );                 
                     }                 
                            


local bConfig := {|| ADhm_extra( bDispBegin,;
                                NIL,;
                                {|| ADrestscn( aScn )};
                               ),;
                     ADhm_row( 5 ),;
                     ADhm_ends( 5, 48 ),;
                     ADhm_pulldown( {1,2,3} );
                 }
local lBlink := setblink( .f. )

ADhormenu( aMenu,;
        ,;
        {;
                {|| X4databases()},;
                {|| X4utilities()},;
                {|| X4quit()};
        },;
        bConfig;
        )
setblink( lBlink )
return nil

//-----------------------
static func X4databases()
local aMenu := { "Client", "Hardware", "Software" }
local aProcess := {;
                    {||ADmessage( { "Client" } )},;
                    {||ADmessage( { "Hardware" } )},;
                    {||ADmessage( { "Software" } )};
                    }
local bConfig := {|| ADvm_color( { "N/W*", "GR+/R", "N/W*", "BG+" } ),;
                        ADvm_boxattr( { "³ " } );
                    }
ADpdmenu(;
            aMenu,;
            ,;
            aProcess,;
            bConfig;
        )
return nil


//-----------------------
static func X4utilities()
local aMenu := { "Reindex", "Backup", "ChangeDirectory" }
local aProcess := {;
                    {||ADmessage( { "Reindex" } )},;
                    {||ADmessage( { "Backup" } )},;
                    {||ADmessage( { "ChangeDirectory" } )};
                    }
local bConfig := {|| ADvm_color( { "N/W*", "GR+/R", "N/W*", "BG+" } ),;
                        ADvm_boxattr( { "³ " } );
                    }
ADpdmenu(;
            aMenu,;
            ,;
            aProcess,;
            bConfig;
        )
return nil


//---------------------
static func X4quit()
local aMenu := { "Yes", "No" }
local bConfig := {|| ADvm_color( { "N/W*", "GR+/R", "N/W*", "BG+" } ),;
                        ADvm_boxattr( { "³ " } );
                    }
if ADpdmenu(;
                aMenu,;
                ,;
                ,;
                bConfig;
            ) = 1
    ADhm_abort()
endif
return nil
