/*
    DB_DEM12.PRG
    Copyright (c) The Programmer's Desk, 1992, 1993.  All rights reserved.

    This sample program demonstrates how you can hot-key the PLUS and MINUS
    keys to increment and decrement numeric and date fields.
*/


// Uncomment the following line if you are using Clipper 5.01.
// #include "f2_501.ch"

#define K_PLUS          43
#define K_CTRL_PLUS     400
#define K_ALT_PLUS      334
#define K_MINUS         45
#define K_CTRL_MINUS    398
#define K_ALT_MINUS     330

//--------------
func db_demo12()
local bConfig := {|| ADdb_keys( {;
                                    K_PLUS,;
                                    K_CTRL_PLUS,;
                                    K_ALT_PLUS,;
                                    K_MINUS,;
                                    K_CTRL_MINUS,;
                                    K_ALT_MINUS;
                                },;
                                {|nth,nkey| Xkeys13( nkey )};
                              );
                 }
local aScn

if "F_TOUR.EXE" $ ADprogname()
    use demo
else
    use ..\demo
    ADset_help( "..\f_tour", { 4,10,20,69 } )
endif

aScn = ADmessage( {;
                    "Press the 'PLUS' key to increment a Numeric field by 1 unit",;
                    "                                  a Date field by 1 day",;
                    "          'CTRL-PLUS' to increment a Numeric by 10 units",;
                    "                                   a Date by 1 week",;
                    "           'ALT-PLUS' to increment a Numeric by 100 units",;
                    "                                   a Date by 1 month",;
                    "",;
                    "Press the corresponding 'MINUS' keys to decrement";
                   }, 12,, .f., .f. )
                    
ADdbview( 0,0,10,79, bConfig,, "TYPICAL" )
ADrestscn( aScn )
use
return nil


//------------------
func Xkeys13( nKey )
local xValue := ADdb_colvalue()
local cType := valtype( xValue )

if cType $ "ND"
    if nKey = K_PLUS
        ADdb_colchange( xValue + 1 )
    elseif nKey = K_CTRL_PLUS
        ADdb_colchange( xValue + if( cType == "N", 10, 7 ) )
    elseif nKey = K_ALT_PLUS
        if cType == "N"
            ADdb_colchange( xValue + 100 )
        else
            ADdb_colchange( ADnextmonth( xValue ) )
        endif
    elseif nKey = K_MINUS
        ADdb_colchange( xValue - 1 )
    elseif nKey = K_CTRL_MINUS
        ADdb_colchange( xValue - if( cType == "N", 10, 7 ) )
    elseif nKey = K_ALT_MINUS
        if cType == "N"
            ADdb_colchange( xValue - 100 )
        else
            ADdb_colchange( ADprevmonth( xValue ) )
        endif
    endif
else
    tone(100,1)
endif
return nil


