/*
    DB_DEM10.PRG
    Copyright (c) The Programmer's Desk, 1992, 1993.  All rights reserved.
*/


#include "inkey.ch"

// Uncomment the following line if you are using Clipper 5.01.
// #include "f2_501.ch"

#include "frankie.ch"


//--------------
func db_demo10()
local cTitleColor := if( iscolor(), "GR+/W", "N/W" )
local aLegendColor := if ( iscolor(), { "W/R", "W+/R" }, { "W/N", "W+/N" } )
local aTitleScn, aLegend
local nT := 4, nL := 3, nB := 16, nR := 76
local bConfig := {|| ;
                     ADdb_extra( {||aTitlescn := ADsavescn( nB+1, nL, nB+1, nR ),;
                                    dispbegin(),;
                                    ADsay( nB+1, nL, padc( "The Frankie Database Browser Demo Program", nR - nL + 1 ), cTitleColor ),;
                                    Xdisprecno( nB, nR, cTitleColor ),;
                                    aLegend := ADlegend(;
                                                            { "Add", "Edit", "Delete", "Recall", "Pack" },;
                                                            {  1,     1,      1,        1,        1  },;
                                                            NIL,;
                                                            aLegendColor,;
                                                            nB+2, nL, nR, 3;
                                                       ),;
                                    ADdb_lbuttons(;
                                                        aLegend[2],;
                                                        {|n,r,c|XColumn(n,c,aLegend[2],nB,nR,cTitleColor)};
                                                    ),;
                                    ADdb_keys(;
                                                    (;
                                                        aadd( aLegend[3], K_ESC ),;
                                                        aLegend[3];
                                                    ),;
                                                    {|n,k|XColumn(n,k,, nB,nR,cTitleColor)};
                                                ),;
                                    ADdb_move( {|| Xdisprecno( nB, nR, cTitleColor )} );
                                 },;
                                 {||dispend()},;
                                 {|| ADrestscn( aLegend[1] ), ADrestscn( aTitleScn )};
                             );
                 }


if "F_TOUR.EXE" $ ADprogname()
    use demo
else
    ADcls( "" )
    ADset_help( "..\f_tour", { 4,10,20,69 } )
    use ..\demo
endif

ADdbview( nT, nL, nB, nR, bConfig,, "TYPICAL" )
use
return nil

#define HOTKEYS     5   // number of hotkeys
#define L_ADD          ascan( { 1, 1+HOTKEYS }, nth ) > 0
#define L_EDIT     ascan( { 2, 2+HOTKEYS }, nth ) > 0
#define L_DELETE      ascan( { 3, 3+HOTKEYS }, nth ) > 0
#define L_RECALL        ascan( { 4, 4+HOTKEYS }, nth ) > 0
#define L_PACK         ascan( { 5, 5+HOTKEYS }, nth ) > 0
#define L_EXIT          nth == HOTKEYS * 2 + 1
//-----------------------------------------------------------
static func Xcolumn( nth, mCol, aSpots, nB, nR, cTitleColor )
ADm_rwait()

if L_ADD
    Xadd11( nB, nR, cTitleColor )
elseif L_EDIT
    Xedit11()
elseif L_DELETE
    delete
    Xdisprecno( nB, nR, cTitleColor )
elseif L_RECALL
    recall
    Xdisprecno( nB, nR, cTitleColor )
elseif L_PACK    
    pack
    ADdb_stabilize( .f., .t. )
    Xdisprecno( nB, nR, cTitleColor )
elseif L_EXIT
    ADdb_exit()
endif

return nil


//------------------------------------
func XDispRecno( nB, nR, cTitleColor )
ADsay( nB+1, nR-10,;
       (;
            padl( ADn2s( recno() ) + "/" +;
            ADn2s( lastrec() ) + if( deleted(), "*", " " ), 10 );
       ),;
       cTitleColor;
     )
return NIL


//-----------
func Xedit11()
field func_name, mouseable, param_num, descriptn, latest_upd
local cColor := setcolor( if( iscolor(), "B/BG, GR+/R", "W+/N, N/W" ) ) 
local nT := 10, nL := 10, nB := 16, nR := 69
local aScn := ADbox( nT, nL, nB, nR )
local cFuncName := func_name, lMouse := mouseable, nParam := param_num
local mDesc := descriptn, dUpdate := latest_upd
local getlist[0], aReadRetval

@nT+1, nL+2 say "Function name         " adget cFuncName
@nT+2, nL+2 say "Is it mouseable?      " adget lMouse picture "Y"
@nT+3, nL+2 say "Number of parameters  " adget nParam
@nT+4, nL+2 say "Description           " adget mDesc picture "@S33" memo
@nT+5, nL+2 say "Date last updated     " adget dUpdate
aReadRetval = ADread( getlist )

if aReadRetval[2] != K_ESC .and. aReadRetval[2] != RX_ABORT
    func_name = cFuncName
    mouseable = lMouse
    param_num = nParam
    descriptn = mDesc
    latest_upd = dUpdate
    ADdb_stabilize( .f., .f. )
endif

setcolor( cColor )
ADrestscn( aScn )
return nil


//--------------------------------
func Xadd11( nB1, nR1, cTitleColor )
field func_name, mouseable, param_num, descriptn, latest_upd
local cColor := setcolor( if( iscolor(), "B/BG, GR+/R", "W+/N, N/W" ) ) 
local nT := 10, nL := 10, nB := 16, nR := 69
local aScn := ADbox( nT, nL, nB, nR )
local cFuncName, lMouse, nParam, mDesc, dUpdate, nRecno := recno()
local getlist[0], aReadRetval

dbgobottom(); dbskip()
cFuncName = func_name; lMouse := mouseable; nParam := param_num
mDesc := space(80); dUpdate := latest_upd

@nT+1, nL+2 say "Function name         " adget cFuncName
@nT+2, nL+2 say "Is it mouseable?      " adget lMouse picture "Y"
@nT+3, nL+2 say "Number of parameters  " adget nParam
@nT+4, nL+2 say "Description           " adget mDesc picture "@S33" memo
@nT+5, nL+2 say "Date last updated     " adget dUpdate
aReadRetval = ADread( getlist )

if aReadRetval[2] != K_ESC .and. aReadRetval[2] != RX_ABORT
    append blank
    func_name = cFuncName
    mouseable = lMouse
    param_num = nParam
    descriptn = mDesc
    latest_upd = dUpdate
    keyboard chr( K_CTRL_PGDN )
    Xdisprecno( nB1, nR1, cTitleColor )
else
    dbgoto( nRecno )
endif

setcolor( cColor )
ADrestscn( aScn )
return nil

