/*
    DB_DEM03.PRG
    Copyright (c) The Programmer's Desk, 1992-94.  All rights reserved.

    This demo demonstrates how to add a title bar, which displays the
    database alias and the record number. 

    Note the following:

    1.  cTitleColor is the color of the title line
    2.  aTitleScn is the screen portion overwritten by the title line.
        It is saved so that it can be restored when the db exits.
    3.  bDispBegin is a codeblock EVALuated by ADdbview() just before
        displaying the initial browse screen.
    4.  bDispEnd is a codeblock EVALuated right after displaying the
        initial browse screen.
    5.  bUndisplay is a codeblock EVALuated just before exiting the
        browse.
    6.  These code blocks are made known to ADdbview() via the API,
        ADdb_extra().
    7.  Xdisp_stat() displays the title line.  It is called once by
        the codeblock, bDispEnd, and everytime the browse cursor
        moves vertically.  ADdbview() is advised to these latter
        type of calls via the API ADdb_move().
    8.  The API messages are sent to ADdbview() via the Configuration
        Specifier, [bConfig].
*/


// Uncomment the following line if you are using Clipper 5.01.
// #include "f2_501.ch"

#include "frankie.ch"

//-------------
func db_demo03()
local cTitleColor, aTitleScn
local bDispBegin := {|| dispbegin()}

// Displays a title bar at row 24
local bDispEnd := {|| cTitleColor := if( iscolor(), "GR+/W", "N/W" ),;
                      aTitleScn := ADbox( 24,0,24,79, cTitleColor, "        ", .f., .f. ),;
                      dispend();
                  }

// Restores the screen covered by the title screen
local bUndisplay := {|| ADrestscn( aTitleScn )}
local bConfig := {|| ADdb_extra( bDispBegin, bDispEnd, bUndisplay ),;
                     ADdb_move( {|| Xdisp_title( cTitleColor )} );
                 }


if "F_TOUR.EXE" $ ADprogname()
    use demo
else
    use ..\demo
    ADset_help( "..\f_tour", { 4,10,20,69 } )
endif

ADdbview( 0,0,23,79, bConfig,, "TYPICAL" )
use
return nil


//-----------------------------
func Xdisp_title( cTitleColor )
local bRecno := {|| " " + padr( alltrim( str( recno() ) ) + "/" + alltrim( str( lastrec() ) ), 15 )}
local nRow := row(), nCol := col()

setpos( 24, 1 )
dispout( alias() + eval( bRecno ), cTitleColor )
setpos( nRow, nCol )
return nil
