/*
         OVERVIEW.RD
         Overview of the Frankie Get/Read Engine.
         Copyright 1992-94 by Angelito Dizon. All rights reserved.
*/


What is the Get/Read Collection?
--------------------------------
The Collection consists of a mouseable READMODAL() replacement engine and
a set of API functions that interact with it for the purpose of
reconfiguring its behavior.


What are its main features?
---------------------------
1.  Mouseable.
2.  @S PICTUREd Gets are expandable to memoedits.
3.  User-definable initially focused Get.
4.  Jump from Get to Get with ALT-keys or mouse click.
5.  Cursor size is synchronized with the _SET_INSERT status.
6.  User-definable time-out routine.
7.  Read-wise validation.
8.  Key-wise validation.
9.  Get-wise updated-status info availability.
10. Deactivate/reactivate a Read.
11. Calculator-type input.
12. Popup validation picklists (from array or database).

Default active ADread() keys
----------------------------
Esc - aborts ADread()

Enter - saves the current Get and transfers focus to the next Get, or
exits ADread() if the current Get is the last Get.

Up, Down - transfers the focus to the adjacent Get.  If these keys have
been configured to act as exit keys (with the use of the API
ADr_exitread(), or if readexit() has been set to TRUE), and the current
Get is the first or last Get, ADread() is exited.

Left, Right - moves the cursor one position to the left or right.  If
these keys have been configured to act as exit keys (with the use of the
API ADr_readexit(), the focus will be set to the adjacent Get if the
cursor is currently in the first or last column position.  If the current
Get is the first or last Get, the ADread() is exited, as well.

Home, End - moves cursor to start or end of the Get

Pgup, PgDn - saves the current Get and exits ADread()

Tab - If the Get is a character and "@S PICTUREd" Get, it will be
expanded to a memoedit.

Ins - toggles between Overwrite and Insert modes.  By default, the cursor
is a solid in Overwrite mode, and an underscore in Insert mode.  The
shape may however be configured.

F1 - displays a Help screen, if available.



Default active left button hot spots
------------------------------------
Any unfocused Get - focuses on that Get

Anywhere on a focused Get:

If the Get is a character and "@S PICTUREd" Get, the cursor will travel
to the location of the mouse cursor while the button is pressed.

On any other Get, the cursor will jump to the location of the mouse
cursor as soon as the button is released.

Top/Left corner of screen - saves and exits the Read

Bottom/Right corner of screen - displays a Help screen if
available.


Default active right button hot spots
-------------------------------------
Anywhere - aborts ADread()


Default active keys in expanded mode
------------------------------------
Esc - aborts the memoedit and returns to the Get
Tab - saves the memoedit and returns to the Get
Ins - toggles between Overwrite and Insert modes
F1 - displays a Help screen if available


Default active left button hot spots in expanded mode
-----------------------------------------------------
"Esc:CloseWindow" - aborts expanded mode
"Tab:Save" - saves the memoedit and returns to the Get
"F1:Help" - displays a Help screen if available


Default active right button hot spots in expanded mode
-----------------------------------------------------
Anywhere - aborts the memoedit and returns to the Get


