/*
        OVERVIEW.RB
        Overview of the Radio Buttons Engine
        Copyright 1992-94 by Angelito Dizon.  All rights reserved.
*/


The Radio Buttons Engine is a painless way of creating radio buttons and
check boxes.

A basic implementation may look like this:

  e := ADrb_create()                // create the engine
  ADrb_add( e,12,14, "The" )              // button #1
  ADrb_add( e,13,14, "Quick Brown Fox" )  // button #2
  ADrb_add( e,14,14, "Jumps" )            // button #3
  ADrb_show( e )                    // display the buttons
  ADrb_activate( e )                // wait for user to make a selection
  ADrb_kill( e )                    // kill the engine

The displayed buttons will look like this while waiting for a user
response.
                                                                                
            ͸
             () The             
             ( ) Quick Brown Fox 
             ( ) Jumps           
                                 
                    Okay         
            ;

The user may now "push" any of the radio buttons by doing any of these:

  1. pressing the highlighted trigger key of the desired option
  2. moving the highlight (an underscore) to the desired option and
     subsequently pressing the space bar
  3. clicking with the mouse

Selecting a button automatically unselects the currently selected button.
There is one button that is currently selected at any time.  To finalize
the selection, press Enter or click the "Okay" button.  To abort press
the Esc or lick the right button.

The above simple call may be configured to:

1.  Change the default colors.
2.  Change the default trigger key.
3.  Change the trigger key from a regular key to an ALT key.
4.  Change the looks of the "Okay" button.
5.  Change the engine's behavior so that it acts like a check box.  A check
    box allows for simultaneous tagging any number of options.
