/*
        OVERVIEW.PB
        Overview of the Push Buttons Engine
        Copyright 1993-94 by Angelito Dizon.  All rights reserved.
*/


The Push Buttons Engine is a painless way of creating push buttons.  When
the buttons are subsequently activated, they may be "pushed" by clicking
them with the mouse or by pressing their trigger keys.

A basic implementation may look like this:

  e := ADpb_create()                // create the engine
  ADpb_add( e,2,4, "The" )          // button #1 starting at 2,4
  ADpb_add( e,2,9, "Quick" )        // button #2 starting at 2,9
  ADpb_add( e,2,16, "Brown" )       // button #3 starting at 2,16
  ADpb_show( e )                    // display the buttons
  ADpb_activate( e )                // wait for user to make a selection
  ADpb_kill( e )                    // kill the engine

The displayed buttons will look like this while waiting for a user
response.
                                                                                
    The  Quick  Brown
    ^    ^      ^

The carets (^) indicate the trigger letters which are highlighted on the
actual screen.

The above simple call may be configured to:

1.  Add shadow to the buttons.
2.  Simulate a "pushing" action when a button is selected.
3.  Change the default colors.
4.  Change the default trigger key.
5.  Change the trigger key from a regular key to an ALT key.

There are two specialized push buttons provided in the library:

1.  Vertical buttons.
2.  Horizontal buttons.

Furthermore, you can create buttons, and "export" them to other Frankie
engines like the Database Browser and the Boxed Read.
