/*
    FDEM10.PRG
*/


#include "frankie.ch"
#include "inkey.ch"

static a[4]

#define COORDS      a[1]
    #define TOP         COORDS[1]
    #define LEFT        COORDS[2]
    #define BOTTOM      COORDS[3]
    #define RIGHT       COORDS[4]
        #define WIDTH               RIGHT - LEFT + 1    // box width
        #define SORT_DISP_LENGTH    WIDTH - 16          // sort display length
        #define STATROW             BOTTOM + 3
        #define PBROW               BOTTOM + 1
#define COLORS      a[2]
    #define STATCOLOR  COLORS[1]
    #define PBCOLOR    COLORS[2]
#define PBENGINE   a[3]                 // push buttons engine
#define MEMOS      a[4]                 // array of memo field positions

//-----------
func fdemo10()
local aArea := ADsavearea()

a := {;
        { 0,0,maxrow()-3,maxcol() },;
        { "GR+/W", { "W+/R", "BG+" } },;
        NIL,;
        NIL;
     }

if "F_TOUR.EXE" $ ADprogname()
    ADset_help( "newdemo\newdemos" )                  
    ADhelp( "ABOUT10" )
    use employee alias fdem10
    set index to emp_num, emp_name, emp_fnam
else
    ADset_help( "newdemos" )
    ADhelp( "ABOUT10" )
    use ..\employee alias fdem10
    set index to ..\emp_num, ..\emp_name, ..\emp_fnam
endif

Xbrowse( a )
use
ADrestarea( aARea )
return NIL


//-------------------
static func Xbrowse()
local aScn
local bConfig := {||ADdb_extra( {||aScn := ADsavescn( BOTTOM+1, LEFT, BOTTOM+3, RIGHT ),;
                                   NIL;
                                },;
                                {||ADcls( " ", ADdb_color()[1], BOTTOM+1,LEFT,BOTTOM+3,RIGHT ),;
                                   ADsay( STATROW, LEFT, space( WIDTH ), STATCOLOR ),;
                                   ADsay( STATROW, LEFT, padc( alias(), 12 ) + "  ", STATCOLOR ),;
                                   XDispIndexKey(),;
                                   XCreatePButtons(),;
                                   ADdb_lbuttons( ADpb_spots( PBENGINE ), {|n|Xhotspots(n)} ),;
                                   ADdb_keys( ADpb_triggers( PBENGINE ), {|n|Xhotkeys(n)} ),;
                                   XWhichAreMemos(),;
                                   ADdb_stabilize( .f., .f. ),;
                                   NIL;
                                },;
                                {||ADrestscn( aScn )};
                              ),;
                    ADdb_hotedges(.f.),;
                    ADdb_keys( {K_F10}, {||ADaview( ADpb_triggers( PBENGINE ) )} );
                 }

ADdbview( TOP, LEFT, BOTTOM, RIGHT, bConfig,, "ABOUT10-BROWSE" )
return NIL


//---------------------------
static func XCreatePButtons()
local aLabels :=   { " Help ", " Sort ", " Top ", " Bot ", " PgUp ", " PgDn ", "  ", "  ", "  ", " " + chr(26) + " ", " Memo ", "  PopUp Menu   " }
local aTriggers := {   2,        2,        2,       2,      1,        1,        1,     1,     1,     1,                    2,         3              }
local bConfig := {||ADpb_colors( PBCOLOR )}

PBENGINE := ADpb_horizontal( PBROW, LEFT+1, aLabels, aTriggers, 1, bConfig )
ADpb_show( PBENGINE, ADparser( ADdb_colors()[1], "/" ) )
return NIL


//------------------------
static func Xhotspots( n )
if n == 1       // help
    ADpb_push( PBENGINE, n )
    ADhelp( "ABOUT10-BROWSE" )
elseif n == 2   // sort
    ADpb_push( PBENGINE, n )
    Xsort()
elseif n == 3   // top
    ADpb_push( PBENGINE, n )
    ADdb_navigate( DBNAVIGATE_TOP )
elseif n == 4   // bottom
    ADpb_push( PBENGINE, n )
    ADdb_navigate( DBNAVIGATE_BOTTOM )
elseif n == 5   // pgup
    ADpb_push( PBENGINE, n )
    ADdb_navigate( DBNAVIGATE_PGUP )
elseif n == 6   // pgdn
    ADpb_push( PBENGINE, n )
    ADdb_navigate( DBNAVIGATE_PGDN )
elseif n == 7   // up
    ADdb_navigate( DBNAVIGATE_UP )
elseif n == 8   // down
    ADdb_navigate( DBNAVIGATE_DOWN )
elseif n == 9   // left
    inkey(.1)      // slow down
    ADdb_navigate( DBNAVIGATE_LEFT )
elseif n == 10  // right
    inkey(.1)      // slow down
    ADdb_navigate( DBNAVIGATE_RIGHT )
elseif n == 11  // memo
    ADpb_push( PBENGINE, n )
    Xgotomemo()
elseif n == 12  // popup
    ADpb_push( PBENGINE, n )
    Xpopup()
endif
return NIL


//------------------------
static func Xhotkeys( n )
n := ADround( n, 2 )

if n == 1       // help
    ADpb_push( PBENGINE, n )
    ADhelp( "ABOUT10-BROWSE" )
elseif n == 2   // sort
    ADpb_push( PBENGINE, n )
    Xsort()
elseif n == 3   // top
    ADpb_push( PBENGINE, n )
    ADdb_navigate( DBNAVIGATE_TOP )
elseif n == 4   // bottom
    ADpb_push( PBENGINE, n )
    ADdb_navigate( DBNAVIGATE_BOTTOM )
elseif n == 11  // memo
    ADpb_push( PBENGINE, n )
    Xgotomemo()
elseif n == 12  // popup
    ADpb_push( PBENGINE, n )
    Xpopup()
endif
return NIL


/*
    Determines which fields are memos.  Returns an array containing
    the field positions of memo fields.
*/
//--------------------------
static func XWhichAreMemos()
MEMOS := {}

if ADdb_fldtype() == "M"
    aadd( MEMOS, ADdb_object():colpos )
endif

do while ADdb_object():colpos < ADdb_object():colcount
    ADdb_navigate( DBNAVIGATE_RIGHT )

    if ADdb_fldtype() == "M"
        aadd( MEMOS, ADdb_object():colpos )
    endif
enddo

ADdb_navigate( DBNAVIGATE_FIRSTCOL )
return NIL


/*
    if there is no memo
        no action
    elseif current field is a memo
        expand it
    else
        go to the next memo and expand it
    endif
*/
//---------------------
static func Xgotomemo()

if len( MEMOS ) > 0
    if ascan( MEMOS, ADdb_object():colpos ) == 0
        if ADdb_object():colpos > atail( MEMOS )
            ADdb_navigate( DBNAVIGATE_FIRSTCOL )
        endif

        do while ADdb_fldtype() != "M"
            ADdb_navigate( DBNAVIGATE_RIGHT )
        enddo


    endif

    keyboard chr( K_TAB )
endif
return NIL


/*
    display index key
*/
//---------------------
static func XDispIndexKey()
local aCsr := ADsavecsr(0)

if indexord() == 0
    ADsay( STATROW, LEFT+15,;
           padr( "natural order", SORT_DISP_LENGTH ),;
           STATCOLOR;
         )
else
    ADsay( STATROW, LEFT+15,;
           padr( indexkey(0), SORT_DISP_LENGTH ),;
           STATCOLOR;
         )
endif

ADrestcsr( aCsr )
return NIL


//-----------------
static func Xsort()
local nOrder := indexord()

// change the sort order
if nOrder == 0
    set order to 1
else
    set order to nOrder + 1

    if indexord() == nOrder
        set order to 0
    endif
endif

// reflect the change in the display
ADdb_stabilize( .f., .t. )

// reflect the index key on the status line
XDispIndexKey()
return NIL


//------------------
static func Xpopup()
local aMenu := {;
                    "Add/Edit/Delete/Pack/Zap",;
                    "Toggle Set Deleted",;
                    "Rearrange Columns",; 
                    "Print the Browse",;
                    "Manage Indexes"; 
               }
local aProcess := {;
                    {||Xmodify()},;
                    {||Xtoggle_Deleted()},;
                    {||Xcolumns()},;
                    {||Xprint()},;
                    {||Xindexes()};
                  }
ADvermenu(,, aMenu,, aProcess,, "ABOUT10-GATEWAY" )
return NIL


//-------------------
static func Xmodify()
local aMenu := {;
                    "Add new record",;
                    "Edit current record",;
                    "Delete current record",;
                    "Pack database",;
                    "Zap database";
               }
ADvermenu( ADvm_row()+1, ADvm_left()+5, aMenu,, {||ADnotyet()},, "ABOUT10-GATEWAY" )
return NIL

//-------------------
static func Xcolumns()
local aMenu := {;
                    "Freeze up to current column",;
                    "Hide current column",;
                    "Show hidden columns",;
                    "Move current column",;
                    "Add a new column",;
                    "Delete current column";
               }
ADvermenu( ADvm_row()+1, ADvm_left()+5, aMenu,, {||ADnotyet()},, "ABOUT10-GATEWAY" )
return NIL


//-------------------
static func Xindexes()
local aMenu := {;
                    "Create a new index",;
                    "Open indexes",;
                    "Recreate indexes";
               }
ADvermenu( ADvm_row()+1, ADvm_left()+5, aMenu,, {||ADnotyet()},, "ABOUT10-GATEWAY" )
return NIL


//------------------
static func Xprint()
local aProcess := {;
                    {||Xtextfile()},;
                    {||Xprinter()},;
                    {||ADbm_abort()};
                  }
ADboxmenu( "Send Output To Where?",;
           { "Textfile", "Printer", "Cancel" },;
           NIL,;
           aProcess,;
           ADvm_row()+1;
         )
return NIL


//---------------------
static func Xtextfile()
static cTextfile

if( cTextfile == NIL, cTextfile := padr( alias()+".PRN", 14 ), )

if ADg_oneb( ADbm_row()+1, ADbm_col(),, "Destination file", @cTextfile )
    ADm_rwait()
    ADnotyet()
endif
return NIL


//--------------------
static func Xprinter()
if ADbm_isprinter()
    ADnotyet()
endif
return NIL


//---------------------------
static func Xtoggle_deleted()
if ADboxmenu( "Deleted is currently " + if( set(_SET_DELETED), "ON", "OFF" ),;
              { "Change", "Retain" };
            ) == 1
    set( _SET_DELETED, !set(_SET_DELETED) )
    ADvm_abort()
    ADdb_stabilize( .f., .t. )
endif
return NIL


