/*
    FDEM03.PRG
    Copyright 1993, Angelito Dizon.  All rights reserved.


    This demo illustrates how to update a Frankie Browse of a database
    containing a numeric field that is calculated from other numeric fields
    when one or more is/are edited.  Two ways are illustrated:  one is when
    the edit is done on the highlighted field, and the second is when the
    edit is done on the whole record.  In both of these methods, the 
    calculated field is not allowed to be directly edited.

    It also illustrates the use of push buttons with a browse.

    To use this demo, you should have Frankie v2.1.  A full-featured
    shareware version is available in these two electronic locations:

        1. CompuServe, Clipper forum, Lib 7
        2. RRR BBS, (301)464-1372, Vendor Support Area

    Look for Frank.zip (Library) and Frankg.zip (NG file).

    To compile: clipper fdem03 /a /b /n /v /w
    To link: blinker (or rtlink) file fdem03 lib frankie 

    Other files needed to run the demo: FDEM03.HLP and FDEM03.HLX (Help files)
*/


//---------
func fdemo03()
local aArea := ADsavearea()
local nPBEngine     // push buttons engine
local aScn          // screen used by the push buttons

if "F_TOUR.EXE" $ ADprogname()
    ADset_help( "newdemo\newdemos" )                  
    ADhelp( "ABOUT04", "About This Demo" )    
    use newdemo\fdem03
else
    ADset_help( "newdemos" )
    ADhelp( "ABOUT04", "About This Demo" )    
    use fdem03
endif

// create a push buttons engine
nPBEngine := ADpb_horizontal( 22, 18,;
                              { " Help ", " EditField ", " EditRecord ", " eXit " },;
                              { 2, 6, 6, 3 },;
                              3;
                            )

ADdbview(,,20,, {||ADdb_extra( NIL,;                                
                               {||aScn := ADsavescn( 21,0,24,79),;  // Save the screen to be occupied by the push buttons
                                  ADcls( " ", "W/BG", 21,0,24,79 ),;
                                  ADpb_show( nPBEngine, "BG" );     // Display the buttons
                               },;     
                               {||ADrestscn( aScn )};               // Restore the screen occupied by the buttons
                             ),;
                   ADdb_keys( ADpb_triggers( nPBEngine ),;          // Define the push buttons as browse hot keys
                              {|n|Xprocess(n, nPBEngine, .t.)};
                            ),;
                   ADdb_lbuttons( ADpb_spots( nPBEngine ),;         // Define the push buttons as browse hot spots
                                  {|n|Xprocess(n, nPBEngine, .f.)};
                                );
                },;
                NIL,;
                "BROWSE";       // Help Identifier for the Browse
        )
use
ADrestarea( aArea )
return NIL


//--------------------------------------
static func Xprocess(n, nPBEngine, lKey)
local aRec, bConfig

if lKey                     // A push button is activated by two keys (upper and lower case).
    n := ADround( n, 2 )    // If a hot key was pushed, interpret the two keys as one.
endif                       // In other words: 'H' and 'h' will be hot key #1, instead of #1 and #2;
                            //                 'F' and 'f' will be hot key #2, instead of #3 and #4;
                            //                 etc.

ADpb_push( nPBEngine, n )   // _push_ the button

if n == 1
    ADhelp( "BROWSE" )
elseif n == 2   // edit the current field
    bConfig := {||ADdbget_dict( {;
                                  {NIL,NIL,{||Xtotal1(1)}},;    // field #1 dictionary
                                  {NIL,NIL,{||Xtotal1(2)}},;    // field #2 dictionary
                                  {NIL,NIL,{||Xtotal1(3)}},;    // field #3 dictionary
                                  {NIL,{||.f.},NIL};            // field #4 dictionary
                                };
                              );
               }
    ADdb_adget( bConfig )   // do the edit
elseif n == 3   // edit the whole record
    aRec := ADgetrec()      // gather the record

    if ADg_many( aRec,;     // edit it
                {||ADgm_color( {"W+/R", "GR+/B", "N/R"} ),; 
                    ADgm_labels( { "Num1", "Num2", "Num3", "Total" } ),;      
                    ADgm_whens( {,,, {||.f.} } ),;    // the 4th Get is not editable      
                    ADgm_valids( { {||Xtotal2()}, {||Xtotal2()}, {||Xtotal2()} } );      
                },;      
                "EDITRECORD";
            )
        ADputrec( aRec )    // save the record if ADg_many() was not aborted
    endif
elseif n == 4
    ADdb_exit()
endif
return NIL


//--------------------
static func Xtotal1(n)
fieldput( 4,;
          fieldget(1) + fieldget(2) + fieldget(3);      // total current values (before the edit)
          - fieldget(n);                                // subtract the old value of the edited field 
          + ADr_varget();                               // then add the new value
        )
ADdb_stabilize( .f., .f. )
return .t.


//-------------------
static func Xtotal2()
// Calculates the sum of the first 3 numeric fields and stores the sum into
// the 4th field.  This is called after editing each of the 3 numerics.
ADr_varput( val( transform( ADr_varget(1) + ADr_varget(2) + ADr_varget(3), "9999" ) ), 4 )
return .t.


