/*
   MISC.PRG
   Tour of Frankie Library Features
   Copyright (c) Angelito Dizon, 1992-94.  All rights reserved.
*/

#include "f_tour.ch"
#include "inkey.ch"
#define nTOP    ADvm_row() + 1
#define nLEFT   ADvm_left() + 8

//-----------
func Xintro()
ADcls( ,,,,,, .T. )

if date() > ctod( "9/15/94" )
    tone(100,2)
    ADmessage( {;
                    "This demo is about 2 months old.  There is probably",;
                    "a newer version.  Check the 'Latest Version' option",;
                    "in the menu for info on how to get it.";
               } )
endif

ADmessage( {;
                "The Frankie Library",;
                "Version " + ADversion(),;
                "A Clipper 5.01/5.2 Protected Mode Compatible",;
                "Library of Mouseable User Interfaces",;
                "",;
                "",;
                "Copyright (c) 1992-94 by Angelito Dizon",;
                "";
           },,, .f., .f. )
ADwait(5)

ADmessage( {;
                "Whenever the program pauses to wait for user",;
                "response, a Help screen may be displayed by",;
                "pressing the F1 key, or clicking the bottom-",;
                "right corner of the screen.",;
                "";
            }, 12, 20,,, { "W+/G", "B/G", "RB+/G*" } )


return nil


//-------------------
func Xabout()   // aEngines )
local aMenu := {;
                    "Frankie",;
                    "Engines",;
                    "Help Facility",;
                    "Other Functions",;
                    "Tour (View Source)",;
                    "Technical Support",;
                    "Latest Version",;
                    "Documentation",;
                    "Author";
               }
local aTrigger := {1,1,1,1,12,1,8,1,1}
local aProcess := {;
                    {|| ADfview( "overview.f",,, "TYPICAL" )},;
                    {|| Xengines( nTOP, nLEFT )},;
                    {|| ADfview( "overview.hp" )},;
                    {|| ADfview( "funclist.f" )},;
                    {|| Xshow_source( nTOP, nLEFT ) },;
                    {|| ADfview( "techsupt.txt" )},;
                    {|| Xlatest()},;
                    {|| ADhelp( "PRINT_DOCS", "Documentation" )},;
                    {|a| a := ADcredit(11,31), ADwait(), ADm_rwait(), ADrestscn( a )};
                  }

ADpdmenu( aMenu, aTrigger, aProcess,, "TYPICAL" )
return nil


//-------------------------
func Xengines( nTop, nCol )
local aMenu := { "Overview of Engines Concept",;
                 "Database Browser Engine",;
                 "Get/Read Engine",;
                 "Boxed Gets Engine",;
                 "Vertical Menu Engine",;
                 "Horizontal Menu Engine",;
                 "Dialog Box Engine",;
                 "Push Buttons Engine",;
                 "Radio Buttons Engine",;
                 "Scroll Bar Engine",;
                 "File Viewer Engine";
               }
local aTrigger := {1,10,5,7,1,1,1,1,2,1,1}
local aProcess := {;
                      {||ADfview( "engines.f",,, "OVERVIEW" )},;
                      {||ADfview( "overview.db",,, "OVERVIEW" )},;
                      {||ADfview( "overview.rd",,, "OVERVIEW" )},;
                      {||ADfview( "overview.gm",,, "OVERVIEW" )},;
                      {||ADfview( "overview.vm",,, "OVERVIEW" )},;
                      {||ADfview( "overview.hm",,, "OVERVIEW" )},;
                      {||ADfview( "overview.bm",,, "OVERVIEW" )},;
                      {||ADfview( "overview.pb",,, "OVERVIEW" )},;
                      {||ADfview( "overview.rb",,, "OVERVIEW" )},;
                      {||ADfview( "overview.sb",,, "OVERVIEW" )},;
                      {||ADfview( "overview.fv",,, "OVERVIEW" )};
                   } 
ADvermenu( nTop, nCol, aMenu, aTrigger, aProcess )
return nil

//-------------------
func Xdemos( aDemos )
local aMenu := {;
                     "Database Browser",;
                     "Get/Read",;
                     "Boxed Gets",;
                     "Vertical Menu",;
                     "Horizontal Menu",;
                     "Dialog Box",;
                     "Push Button",;
                     "Radio Buttons",;
                     "Scroll Bar",;
                     "File Viewer",;
                     "Help Facility",;
                     "New Demos",;
                     "User Contributed Demos";
               }
local aTrigger := {10,5,7,1,1,1,1,2,1,1,13,1,1}
local aProcess := {;
                    {||Xdbview( nTOP, nLEFT )},;
                    {||Xread( nTOP, nLEFT )},;
                    {||Xboxedgets( nTOP, nLEFT )},;
                    {||Xvermenu( nTOP, nLEFT )},;
                    {||Xhormenu( nTOP, nLEFT )},;
                    {||Xboxmenu( nTOP, nLEFT )},;
                    {||Xpushbutton( nTOP, nLEFT )},;
                    {||Xradiobutton( nTOP, nLEFT )},;
                    {||Xscrollbar( nTOP, nLEFT )},;
                    {||Xshowfile( nTOP, nLEFT )},;
                    {||XhelpFacility( nTOP, nLEFT )},;
                    {||Xnewdemos( nTOP, nLEFT )},;
                    {||Xuserdemos( nTOP, nLEFT )},;
                  }
ADpdmenu( aMenu, aTrigger, aProcess, {||NIL}, "TYPICAL" )
return nil


//-------------------------
func Xregister()
local aMenu := {;
                 "Why Should You Register?",;
                 "Registration Cost",;
                 "How to Register?",;
                 "Fill Out Registration Form",;
                 "Print Blank Registration Form";
               }
local aProcess := {;
                    {||ADhelp( "WHY_REG", aMenu[1] )},;
                    {||ADhelp( "REG_COST", aMenu[2] )},;
                    {||ADhelp( "HOW_TO_REG", aMenu[3] )},;
                    {||Xfill_reg()},;
                    {||ADfprint( "register.frm" )};
                  }
ADpdmenu( aMenu, {1,14,1,1,1}, aProcess, {||NIL}, "TYPICAL" )
return nil


//--------------
func Xfill_reg()
local aPayMode := {;
                    "Check or MO",;
                    "Master Card",;
                    "Visa       ",;
                    "Am Express ",;
                    "Discover   ";
                  }
local cName := space( 30 )
local cAddress1 := space( 50 )
local cAddress2 := space( 50 )
local cAddress3 := space( 50 )
local cAddress4 := space( 50 )
local cPhone    := space( 50 )
local cFax      := space( 50 )
local cLearn    := space( 50 )
local cPayMode := space( 11 )
local cCardNum := space( 50 )
local cExpDate := space( 50 )
local cHolder  := space( 50 )
local getlist[0], bConfig
local nT := 6, nL := 3
local nB := nT+15, nR := nL + 71
local aScn := ADbox( nT, nL, nB, nR )

ADcsay( nT, nL, nR, " Registration " )
@nT+1, nL+2  say "Customer's Name   " adget cName
@nT+2, nL+2  say "        Address   " adget cAddress1
@nT+3, nL+2  say "                  " adget cAddress2
@nT+4, nL+2  say "                  " adget cAddress3
@nT+5, nL+2  say "                  " adget cAddress4
@nT+6, nL+2  say "          Phone   " adget cPhone
@nT+7, nL+2  say "            Fax   " adget cFax
@nT+8, nL+2  say "Heard Frankie From" adget cLearn
@nT+9, nL+34 say "(Press F10 for picklist)"
@nT+9, nL+2  say "Payment Mode      " adget cPayMode;
                                     valid ADr_popup( ,, aPayMode )
ADsay( nT+10, nL, "" + padc( "Info below is required for card payment", nR-nL-1, "" ) + "" )
@nt+11, nL+2 say "Card Number       " adget cCardNum;
                                     when ( trim( ADr_varget(9) ) $ "Master Card,Visa,Am Express,Discover" )
@nt+12, nL+2 say "Expiration Date   " adget cExpDate;
                                     when ( trim( ADr_varget(9) ) $ "Master Card,Visa,Am Express,Discover" )
@nT+13, nL+2 say "Cardholder's Name " adget cHolder;
                                      when ( trim( ADr_varget(9) ) $ "Master Card,Visa,Am Express,Discover" )
@nT+14, nL+2 say "Cardholder's Phone" adget cPhone;
                                      when ( trim( ADr_varget(9) ) $ "Master Card,Visa,Am Express,Discover" )
bConfig := {|| ADr_exit( {||Xexit( aPayMode )} ),;
               ADr_keys( { K_F10 }, ;
                         {||if( ADr_varname() == "CPAYMODE",;
                                ADr_popup( ,, aPayMode,, .t. ),;           
                                NIL;           
                              );
                         };           
                       );
           }
ADread( getlist, bConfig )
ADrestscn( aScn )
return nil


//--------------------
func Xexit( aPayMode )
local lExit := .f.


if ascan( aPayMode, ADr_varget( 9 ) ) > 1
    if ADr_filled( { 10,11,12,13 } )
        lExit := .T.
    else
        ADmessage( { "Incomplete Credit Card Info" } )
    endif
else
    lExit := .T.
endif

if lExit
    if ascan( { RX_ABORT, K_ESC }, ADr_exitcode() ) == 0
        if ADboxmenu( "Print Registration Form?", { " Yes ", " No " }, {2,2} ) == 1
            if ADbm_isprinter()
                Xprint_reg( ADr_varget(1), ADr_varget(2), ADr_varget(3),;
                            ADr_varget(4), ADr_varget(5), ADr_varget(6),;
                            ADr_varget(7), ADr_varget(8), ADr_varget(9),;
                            ADr_varget(10), ADr_varget(11), ADr_varget(12),;
                            ADr_varget(13) )
            else
                lExit := .F.
            endif
        else
            lExit := .F.
        endif
    endif
endif

return lExit



#define MARGIN "        "

//-----------------------------------------------------------------------
func Xprint_reg( cName, cAddress1, cAddress2, cAddress3, cAddress4,;
                 cPhone1, cFax, cLearn, cPayMode,;
                 cCardNum, cExpDate , cHolder, cPhone2 )
local aScn := ADmessage( {"Printing Registration Form" },,, .f., .f. )
local h_input := fopen( "register.frm" )
local h_output := 4, cLine

do while ! "Name:" $ ( cLine := ADfgetl( h_input ) )
    fwrite( h_output, cLine + LINEFEED )
enddo

fwrite( h_output, MARGIN + "Name   : " + cName + LINEFEED )
fwrite( h_output, MARGIN + "Address: " + cAddress1 + LINEFEED )
fwrite( h_output, MARGIN + "         " + cAddress2 + LINEFEED )
fwrite( h_output, MARGIN + "         " + cAddress3 + LINEFEED )
fwrite( h_output, MARGIN + "         " + cAddress4 + LINEFEED )
fwrite( h_output, MARGIN + "Phone  : " + cPhone1 + LINEFEED )
fwrite( h_output, MARGIN + "Fax    : " + cFax + LINEFEED )
fwrite( h_output, MARGIN + "Learned: " + cLearn + LINEFEED )
fwrite( h_output, MARGIN + LINEFEED + LINEFEED + MARGIN + repl( "-",  58 ) + LINEFEED + LINEFEED )

if cPayMode == "Check or MO"
    fwrite( h_output, MARGIN + "Payment by: " + cPayMode + LINEFEED + LINEFEED )

    do while ! "Remit Check" $ ( cLine := ADfgetl( h_input ) )
    enddo

    fwrite( h_output, cLine + LINEFEED )

    do while ! "-------" $ ( cLine := ADfgetl( h_input ) )
        fwrite( h_output, cLine + LINEFEED )
    enddo    
else
    fwrite( h_output, MARGIN + "Payment by: " + cPayMode + LINEFEED + LINEFEED )
    fwrite( h_output, MARGIN + "Card #:          " + cCardNum + LINEFEED )
    fwrite( h_output, MARGIN + "Expiration Date: " + cExpDate + LINEFEED )
    fwrite( h_output, MARGIN + "Cardholder:      " + cHolder + LINEFEED )
    fwrite( h_output, MARGIN + "Phone:           " + cPhone2 + LINEFEED + LINEFEED )

    do while ! "Remit credit" $ ( cLine := ADfgetl( h_input ) )
    enddo

    fwrite( h_output, cLine + LINEFEED )

    do while ! "-------" $ ( cLine := ADfgetl( h_input ) ) .and. !ADfeof( h_input )
        fwrite( h_output, cLine + LINEFEED )
    enddo    
endif



fwrite( h_output, FORMFEED )
fclose( h_input )
return nil


//---------------------
func Xquit()
local aMenu := { "Yes", "No" }
if ADpdmenu( aMenu,,, {||NIL} , "TYPICAL" ) = 1
    ADhm_abort()
endif
return nil


//------------------------------
func Xshow_source( nTop, nLeft )
local bProcess := {|| ADfview( ADvm_current() )}
ADpl_files( nTop, nLeft,, "*.prg", bProcess )
return nil


//---------------------------
func Xprintrun( cFile, bRun )
local cColor
local aMenu := { "Run Demo", "Print" }
local bProcess := {|n| if( n == 2,;
                           ADfprint(cFile),;
                           (;
                                cColor := setcolor(),;
                                eval( bRun ),;
                                setcolor( cColor );
                           );
                         );
                  }
ADfv_vermenu( aMenu,, bProcess )
return nil


//-------------
func X501test()
local aMsg :=  {;
                 "",;
                 "WARNING!",;
                 "",;
                 "F2_501.LIB was not linked.  The program may not work",;
                 "properly in some areas.  For more information please",;
                 "see the NOTE TO CLIPPER 5.01 USERS section in the   ",;
                 "README file that came with this package.            ",;
                 "";
                }

if type( "ORDSETFOCU()" ) == "U" .and. type( "DBSETORDER()" ) == "U"
    tone(100,3)
    if ADboxmenu( aMsg, { "Continue", "Quit" } ) == 2
        quit
    endif
endif
return nil


//---------
func Xbye()
ADmessage( { "Now a couple of words from The Programmer's Desk" },,,,, { "W+/B", "R+/B" } )
ADfview( "USERS.TXT" )
ADhelp( "PRINT_DOCS", "Documentation" )
ADcredit(11,31)
return NIL


//-------------
func Xupgrade()
local aMenu := {;
                 "Upgrade Cost",;
                 "Fill Out Upgrade Form",;
                 "Print Blank Upgrade Form";
               }
local aProcess := {;
                    {||ADhelp( "UPGRADE_COST", aMenu[2] )},;
                    {||Xfill_upgrade()},;
                    {||ADfprint( "upgrade.frm" )};
                  }
ADpdmenu( aMenu,, aProcess, {||NIL}, "TYPICAL" )
return NIL


//------------------
func Xfill_upgrade()
local cName := space( 50 )
local cAddress1 := space( 50 )
local cAddress2 := space( 50 )
local cAddress3 := space( 50 )
local cAddress4 := space( 50 )
local cPhone := space( 50 )
local cFax := space( 50 )
local cRegNum := space(5)
local getlist[0], bConfig
local nT := 10, nL := 4
local nB := nT+9, nR := nL + 72
local aScn := ADbox( nT, nL, nB, nR )

ADcsay( nT, nL, nR, " Frankie v2.2 Upgrade " )
@nT+1, nL+2 say "Customer's Name   " adget cName
@nT+2, nL+2 say "        Address   " adget cAddress1
@nT+3, nL+2 say "                  " adget cAddress2
@nT+4, nL+2 say "                  " adget cAddress3
@nT+5, nL+2 say "                  " adget cAddress4
@nT+6, nL+2 say "          Phone   " adget cPhone
@nT+7, nL+2 say "            Fax   " adget cFax
@nT+8, nL+2 say "Frankie Serial#   " adget cRegNum picture "99999"
bConfig := {|| ADr_exit( {||Xexit_upg()} )}
ADread( getlist, bConfig )
ADrestscn( aScn )
return nil


//--------------
func Xexit_upg()
local lExit := .f.
local aCsr := ADsavecsr()

if ascan( { RX_ABORT, K_ESC }, ADr_exitcode() ) == 0
    if ADboxmenu( "Print Upgrade Form?", { " Yes ", " No " }, {2,2} ) == 1
        if ADbm_isprinter()
            Xprint_upg( ADr_varget(1), ADr_varget(2), ADr_varget(3),;
                        ADr_varget(4), ADr_varget(5), ADr_varget(6),;
                        ADr_varget(7), ADr_varget(8);
                        )
        else
            lExit := .F.
        endif
    else
        lExit := .F.
    endif
endif

ADrestcsr( aCsr )
return lExit


//------------------------------------------------------------------
func Xprint_upg( cName, cAddress1, cAddress2, cAddress3, cAddress4,;
                 cPhone, cFax, cRegNum )
local aScn := ADmessage( {"Printing Upgrade Form" },,, .f., .f. )
local h_input := fopen( "upgrade.frm" )
local h_output := 4, cLine

do while ! "Name:" $ ( cLine := ADfgetl( h_input ) )
    fwrite( h_output, cLine + LINEFEED )
enddo

fwrite( h_output, MARGIN + "Name:    " + cName + LINEFEED )
fwrite( h_output, MARGIN + "Address: " + cAddress1 + LINEFEED )
fwrite( h_output, MARGIN + "         " + cAddress2 + LINEFEED )
fwrite( h_output, MARGIN + "         " + cAddress3 + LINEFEED )
fwrite( h_output, MARGIN + "         " + cAddress4 + LINEFEED )
fwrite( h_output, MARGIN + "  Phone: " + cPhone + LINEFEED )
fwrite( h_output, MARGIN + "    Fax: " + cFax + LINEFEED )
fwrite( h_output, MARGIN + "Frankie Registration #: " + cRegNum + LINEFEED )

do while ! "(Important:" $ ( cLine := ADfgetl( h_input ) )
enddo

fwrite( h_output, cLine + LINEFEED )

do while !ADfeof( h_input )
    fwrite( h_output, ADfgetl( h_input ) + LINEFEED )
enddo

fwrite( h_output, FORMFEED )
fclose( h_input )
ADrestscn( aScn )
return nil


//------------
func Xlatest()
ADmessage ( {;
                "Enhancement work on Frankie is a continuous effort at",;
                "The Programmer's Desk.  Announcements are regularly",;
                "posted in an electronic newsletter.  If you are",;
                "wondering whether you have the latest version,",;
                "download the file FRANKN.ZIP from either the Clipper",;
                "Forum, Lib 7 in Compuserve, from the RRR Bulletin",;
                "Board at (301)464-1372 or from the Internet FTP site",;
                "CLIPPER.PSYCH.UW.EDU.PL.";
             };
          )
return NIL



