/*
        ENGINES.F
        Overview of Frankie Engines
        Copyright 1992-94 by Angelito Dizon.  All rights reserved.
*/

A Frankie engine is a self-contained entity that does a specific
function.  Like an object, it contains the procedures and data that it
needs to accomplish its purpose.  Every engine has its own default
behavior, looks, and functionality, which can be reconfigured via a set
of APIs.

In version 1 of Frankie, the engines are almost transparent to the
programmer.  A user-interface creates an engine, manipulates and
otherwise processes it, then kills it, without much intervention by the
programmer.  The farthest extent that the programmer knows about the
engine is in some of the APIs where he has to make sure that the API he
uses passes an engine identifier.

In version 2, new engines were added to the library.  Here, the engine
concept is more formally defined than in the original Frankie 1 engines. 
The programmer may assume a greater responsibility, if he so desires, in
the manipulation of the engine configuration.  This makes for greater
flexibility and openness of the library.

In version 2.2, the flexibility has been even more enhanced.  You can now
define your own custom event handlers for many of the engines.

If the Frankie engine concept is new to you, you may conceptualize an
engine as something akin to a file handle.  When you open a file with
F_OPEN(), you get a file handle.  To process the file you opened, you
pass the file handle to the processing functions like F_READ(),
F_WRITE(), F_CLOSE(), etc.  In the same manner, you process a Frankie
engine by passing its identifier to an API.  Some users made the
observation that the APIs are similar to the methods in OOP.

Common Engine Behavior
----------------------
F1 - Displays a Help screen if one has been defined.

ALT-0 - EVALuates the Developer's Block.  The default block is merely a
{|e|nil}.  It can however be globally set by ADdevblock().  For example,

ADdevblock( {|e| tone(100,1)} ) // will beep the speaker for
                                // whatever purpose.

ADdevblock( {|e| ADaview( ADtrace() )} ) // will display a
                                         // procedure trace

ADdevblock( {|e| ADmessage( { ADn2s( memory(0) ),;
                                ADn2s( memory(1) ),;
                                ADn2s( memory(2) ) } )
                                // displays the  memory values

ADdevblock( {|e| swpruncmd( "", 0, "", "" )} )
                        // will shell to Dos, swapping as much 
                        // memory as possible, if app is
                        // linked with  Blinker.


Click on top/left corner of screen - makes a selection (only for
selection engines like ADvermenu(), ADhormenu(), etc.)

Click on bottom/right corner of screen - displays a Help screen
if one has been defined for the current context.      

Click on top/left corner with right button - same as pressing
ALT-0.  (New in v2.2)
