*  Program.....: MAKELINK.PRG
*  Authors.....: Peter Volz
*  Copyright(c): 1989-1994 SmartCode Programming, All rights reserved.
*  Application.: BroPlus Professional Xbase Browse Utility & File Manager
*  Version.....: Clipper 5.01 / 5.2
*  Compile.....: clipper makelink /m /w
*  Functions...: FetchInput( ary )
*                MakeScript( ary )
*
***************************************************************************

#xcommand Out <cString>   =>    fWrite( i, <cString> + chr(13) + chr(10) )

#define  CLVER            ary[1]
#define  LINKER           ary[2]
#define  BLVER            ary[3]
#define  BLMODE           ary[4]
#define  BPMODE           ary[5]
#define  HICOLOR          ary[6]
#define  OVLSWAP          ary[7]
#define  NTX              ary[8]
#define  NTXLOCK2         ary[9]
#define  NDX              ary[10]
#define  MDX              ary[11]
#define  CDX              ary[12]
#define  CDXFOX           ary[13]
#define  SIX              ary[14]
#define  SIXVER           ary[15]
#define  SIXCDX           ary[16]
#define  SIXFOX           ary[17]
#define  SIXNC            ary[18]
#define  SIXNSX           ary[19]
#define  SIXNTX           ary[20]
#define  SIXENC           ary[21]
#define  SIXDBT           ary[22]
#define  SIXINTL          ary[23]
#define  SIXNATIO         ary[24]
#define  DBFNSX           ary[25]
#define  CMX              ary[26]
#define  CX3              ary[27]
#define  CX3FOX           ary[28]
#define  CX3DBT           ary[29]
#define  CMXINTL          ary[30]
#define  FLEX             ary[31]
#define  FLEXVER          ary[32]
#define  FLEXRDD          ary[33]
#define  MORELIBS         ary[34]
#define  MOREOBJS         ary[35]
#define  REQUESTS         ary[36]

#define LNKFILE   "BROPLUS.LNK"
#define RDDPRG    "RDDRQST.PRG"

#define  TRUE             .t.
#define  FALSE            .f.

local lMore    := TRUE
local iChoice1 := 2      // does link script exist?
local iChoice2 := 0      // accept selections?
local ary[36]            // array of input choices

   // Default values
   CLVER       := "2"
   LINKER      := "B"
   BLVER       := "3"
   BLMODE      := "R"

   BPMODE      := "F"
   HICOLOR     := TRUE
   OVLSWAP     := FALSE

   NTX         := TRUE
   NTXLOCK2    := FALSE
   NDX         := FALSE
   MDX         := FALSE
   CDX         := FALSE
   CDXFOX      := FALSE

   SIX         := FALSE
   SIXVER      := "1"
   SIXCDX      := FALSE
   SIXFOX      := FALSE
   SIXNC       := FALSE
   SIXNSX      := FALSE
   SIXNTX      := FALSE
   SIXENC      := FALSE
   SIXDBT      := FALSE
   SIXINTL     := FALSE
   SIXNATIO    := space(10)

   DBFNSX      := FALSE

   CMX         := FALSE
   CX3         := FALSE
   CX3FOX      := FALSE
   CX3DBT      := FALSE
   CMXINTL     := FALSE

   FLEX        := FALSE
   FLEXVER     := "2"
   FLEXRDD     := FALSE

   MORELIBS    := space(64)
   MOREOBJS    := space(64)
   REQUESTS    := space(64)

   setcolor( "W+/B,W+/R,,,B/W" )
   setmode( 50,80 )
   set scoreboard off
   cls
   @ 0, 0 to maxrow(), maxcol()  // draw box

   if file( LNKFILE )
   
      iChoice1 := Alert( LNKFILE + " exists!; "                        +;
                 "You may either: Bypass link script creation and;"    +;
                 "create BroPlus from the existing link script,;"      +;
                 "or: Overwrite the script, or: Cancel the operation",  ;
                  { "ByPass", "Overwrite", "Cancel"} )

      lMore := iChoice1 == 2  // Enter FetchInput only if "Overwrite"
      
   endif


   @ 2, 25 say "Enter your link options below"

   while lMore

      FetchInput( ary )

      iChoice2 := Alert("Accept Selections?", { "Yes", "No", "Cancel" })

      if iChoice2 % 2 <> 0
         lMore := FALSE
      endif

   end

   lMore := iChoice1 % 3 <> 0  .and. iChoice2 <> 3

   if iChoice2 == 1 .and. MakeScript( ary )

      lMore := Alert("File " + LNKFILE + if( CLVER=="2", " & " + RDDPRG, "")+;
             " successfully created!;" + ;
             "Create the BroPlus executable NOW?", { "Yes", "No" } ) == 1
   endif

   if .not. lMore
      ErrorLevel(1)
   endif

   cls
   setmode( 25,80 )

return

*============================================================================

function FetchInput( ary )

local getlist := {}
local i := 4      // screen row

   @ i++, 5 say "Clipper version: 5.0<1> or 5.<2>                   (1/2) " ;
            get CLVER                                                       ;
            valid CLVER == "2"   // $ "12"

   @ i++, 5 say "Linker to use: <R>tlink / <B>linker / <E>xoSpace (R/B/E) " ;
            get LINKER                                                      ;
            picture "!"                                                     ;
            valid LINKER $ "RBE"

   @ i++, 5 say "Blinker version: <2>.x or <3>.x                    (2/3) " ;
            get BLVER                                                       ;
            valid BLVER $ "23"                                              ;
            when LINKER == "B"

   @ i++, 5 say "If Blinker 3: <R>eal / <E>xtended / <D>ual mode  (R/E/D) " ;
            get BLMODE                                                      ;
            picture "!"                                                     ;
            valid  BLMODE $ "RED"                                           ;
            when LINKER == "B" .and. BLVER == "3"
   i++

   @ i++, 5 say "Create BroPlus <F>ull version or <R>untime version (F/R) " ;
            get BPMODE                                                      ;
            picture "!"                                                     ;
            valid BPMODE $ "FR"

   @ i++, 5 say "OK to use High-Intensity Background Colors?        (Y/N) " ;
            get HICOLOR                                                     ;
            picture "Y"

   @ i++, 5 say "Use Overlay() by SoftDesign for Swapping to DOS?   (Y/N) " ;
            get OVLSWAP                                                     ;
            picture "Y"                                                     ;
            when LINKER == "R"
   i++

   @ i++, 5 say "Include Clipper's DBFNTX driver?                   (Y/N) " ;
            get NTX                                                         ;
            picture "Y"

   @ i++, 5 say "Enable 5.2-specific index locking (NTXLOCK2.OBJ)?  (Y/N) " ;
            get NTXLOCK2                                                    ;
            picture "Y"                                                     ;
            when NTX .and. CLVER == "2"

   @ i++, 5 say " (Don't answer 'Yes' unless you know what it means)"

   @ i++, 5 say "Include Clipper's DBFNDX driver?                   (Y/N) " ;
            get NDX                                                         ;
            picture "Y"

   @ i++, 5 say "Include Clipper's DBFMDX driver?                   (Y/N) " ;
            get MDX                                                         ;
            picture "Y"                                                     ;
            when CLVER == "2"

   @ i++, 5 say "Include Clipper's DBFCDX driver?                   (Y/N) " ;
            get CDX                                                         ;
            picture "Y"                                                     ;
            when CLVER == "2"

   @ i++, 5 say "Enable FoxPro compat. record locking with DBFCDX?  (Y/N) " ;
            get CDXFOX                                                      ;
            picture "Y"                                                     ;
            when CLVER == "2" .and. CDX
   i++

   @ i++, 5 say "Include SIx Driver - SIXCDX or SIXNSX or SIXNTX?   (Y/N) " ;
            get SIX                                                         ;
            picture "Y"                                                     ;
            when .not. ( CLVER == "1" .and. NDX )

   @ i++, 5 say "SIx Driver version: <1>.5 or <2>.0                 (1/2) " ;
            get SIXVER                                                      ;
            valid SIXVER $ "12"                                             ;
            when SIX .and. CLVER == "2"

   @ i++, 5 say "Include SIXCDX (CDX indexes, FPT memos)?           (Y/N) " ;
            get SIXCDX                                                      ;
            picture "Y"                                                     ;
            when SIX .and. .not. CDX

   @ i++, 5 say "Enable FoxPro compat. record locks w/ SIXCDX 1.5 ? (Y/N) " ;
            get SIXFOX                                                      ;
            picture "Y"                                                     ;
            when SIX .and. SIXCDX .and. SIXVER == "1" .and. .not. CDX


   @ i++, 5 say "Support Foxbase+ non-compact .IDX index files?     (Y/N) " ;
            get SIXNC                                                       ;
            picture "Y"                                                     ;
            when SIX .and. SIXCDX .and. SIXVER == "1" .and. .not. CDX


   @ i++, 5 say "Include SIXNSX (NSX indexes, SMT memos)?           (Y/N) " ;
            get SIXNSX                                                      ;
            picture "Y"                                                     ;
            when CLVER == "2" .and. SIX

   @ i++, 5 say "Include SIXNTX?                                    (Y/N) " ;
            get SIXNTX                                                      ;
            picture "Y"                                                     ;
            when CLVER == "2" .and. SIXVER == "2" .and. SIX .and. .not. NTX
                 

   @ i++, 5 say "Support SIx Driver data encryption / decryption?   (Y/N) " ;
            get SIXENC                                                      ;
            picture "Y"                                                     ;
            when SIX .and. ( CLVER == "2" .or. SIXCDX )

   @ i++, 5 say " (Not recommended since it slows down Browse speed)"

   @ i++, 5 say "Replace native SIx Memo support with .DBT memos?   (Y/N) " ;
            get SIXDBT                                                      ;
            picture "Y"                                                     ;
            when SIX .and. ( CLVER == "2" .or. SIXCDX )

   @ i++, 5 say "Use International version of the SIx Driver?       (Y/N) " ;
            get SIXINTL                                                     ;
            picture "Y"                                                     ;
            when SIX .and. ( CLVER == "2" .or. SIXCDX )

   @ i++, 5 say "Enter name of your nation module, e.g. 'SIXGER.OBJ'   => " ;
            get SIXNATIO                                                    ;
            picture "@!"                                                    ;
            when SIX .and. SIXINTL
   i++

   @ i++, 5 say "Include DBFNSX Rdd - HiPer-SIx?                    (Y/N) " ;
            get DBFNSX                                                      ;
            picture "Y"                                                     ;
            when CLVER == "2" .and.                                         ;
                 ( .not. SIX  .or.  SIXVER == "1" .and. .not. SIXNSX )
   i++

   @ i++, 5 say "Include Comix RDD v. 1.x - CMX/PCB index files?    (Y/N) " ;
            get CMX                                                         ;
            picture "Y"                                                     ;
            when CLVER == "2"

   @ i++, 5 say "Include Comix RDD v. 3.x - CDX indexes, FPT memos? (Y/N) " ;
            get CX3                                                         ;
            picture "Y"                                                     ;
            when CLVER == "2" .and. .not. CMX

   @ i++, 5 say "Replace native Comix Memo support with .DBT memos? (Y/N) " ;
            get CX3DBT                                                      ;
            picture "Y"                                                     ;
            when CLVER == "2" .and. CX3

   @ i++, 5 say "Enable FoxPro compatible record locking w/ Comix?  (Y/N) " ;
            get CX3FOX                                                      ;
            picture "Y"                                                     ;
            when CLVER == "2" .and. CX3

   @ i++, 5 say "Enable international indexing support with Comix?  (Y/N) " ;
            get CMXINTL                                                     ;
            picture "Y"                                                     ;
            when CLVER == "2" .and. ( CMX .or. CX3 )
     i++

   @ i++, 5 say "Include FlexFile support?                          (Y/N) " ;
            get FLEX                                                        ;
            picture "Y"

   @ i++, 5 say "FlexFile version:  <1>.x or <2>.x                  (1/2) " ;
            get FLEXVER                                                     ;
            picture "!"                                                     ;
            valid FLEXVER $ "12"                                            ;
            when FLEX

   @ i++, 5 say "If FlexFile version 2: Support FlexFile RDD?       (Y/N) " ;
            get FLEXRDD                                                     ;
            picture "Y"                                                     ;
            when FLEX .and. FLEXVER == "2"
   i++

   @ i++, 5 say "Additional LIBs if any, separated by comma  =>"            ;
            get MORELIBS                                                    ;
            picture "@!S25"

   @ i++, 5 say "Additional OBJs if any, separated by comma  =>"            ;
            get MOREOBJS                                                    ;
            picture "@!S25"

   @ i++, 5 say "EXTERNAL references if any, sep. by comma   =>"            ;
            get REQUESTS                                                    ;
            picture "@S25"
   read

return NIL

*============================================================================

function MakeScript( ary )

local i     // file handle for BROLINK.LNK & RDDRQST.PRG
local cDef  // default RDD if not DBFNTX

if ( i := fCreate( LNKFILE, 0 ) ) == -1
   Alert( "Error creating link file" )
   return FALSE
endif

// Header
Out "## " + LNKFILE
Out "##"
Out "## BroPlus Database Browse Utility System, Version 2.50"
Out "## " + dtoc( date() ) + "  " + time()
Out "## Copyright(c) 1989-1994 SmartCode Programming, All rights reserved."
Out "##"
Out "## Custom linker response file"
Out "##"

// script content
if LINKER == "B"  // Blinker

   Out    "BLINKER INCREMENTAL OFF"
   Out    "BLINKER EXECUTABLE CLIPPER F65;CGACURS;BADCACHE"
   Out    "BLINKER MESSAGE NOBLINK"
   Out    "BLINKER OVERLAY UMB ON"
   Out    "BLINKER OVERLAY PAGEFRAME ON"
   Out    ""

   if BLVER == "3"
    if BLMODE == "E"
      Out "BLINKER EXECUTABLE EXTENDED"
    elseif BLMODE == "D"
      Out "BLINKER EXECUTABLE DUAL"
    endif
   endif

elseif LINKER == "E" // ExoSpace

   if CLVER == "1"
      Out "EXOSPACE CLIPPER 501"
   endif
   Out    "EXOSPACE EXECUTABLE CLIPPER F65;CGACURS;BADCACHE"
   Out    ""

else                 // Rtlink nothing is needed
endif

// create map file
if LINKER $ "BE"
   Out    "MAP S,A"
endif

Out       "OUTPUT BRO"

// Stack setting for Comix
if CLVER == "2" .and. ( CMX .or. CX3 )
   Out    "STACK 7168"
endif
Out       ""

// Full- or Run-Time version
if BPMODE == "F"
   Out    "FILE BRO"
else
   Out    "FILE BRORUN"
endif

// Overlay for swapping to DOS
if LINKER == "R" .and. OVLSWAP
   Out    "FILE RESIDENT"
endif

// Fixes for 5.01a problems
if CLVER == "1"
   Out    "FILE EVESIX"
   Out    "FILE EMM501"

   // SIx Driver / 5.01a particulars
   if SIX .and. SIXCDX
      Out "FILE FGET"
      if NTX
         Out "FILE DBCREATE"
      else
         Out "FILE SIXCDX"
      endif
   endif
endif

// NTX index locking at Hex FFFFFFFF ?
if CLVER == "2" .and. NTX .and. NTXLOCK2
   Out    "FILE NTXLOCK2"
endif

// DBFCDX and Fox locking
if CLVER == "2" .and. CDX .and. CDXFOX
   Out    "FILE CDXLOCK"
endif

// SIXCDX 1.5 and Fox locking
if SIX .and. SIXVER == "1" .and. SIXCDX .and. SIXFOX
   Out    "FILE FOXLOCK"
endif

// Comix 3 and Fox locking
if CLVER == "2" .and. CX3 .and. CX3FOX
   Out    "FILE CMXFOX52"
endif

if SIX
   // SIx driver and DBT memos
   if SIXDBT
      Out "FILE DBT"
   endif
   // SIx driver international
   if SIXINTL .and. .not. empty( SIXNATIO )
      Out "FILE " + SIXNATIO
   endif
endif

// Comix 3 and DBT memos
if CLVER == "2" .and. CX3 .and. CX3DBT
   Out    "FILE CMXDBT52"
endif

// non-compakt .IDX file support
if SIX .and. SIXCDX .and. SIXVER == "1" .and. SIXNC
   if LINKER == "B"
      Out "SEARCH SIXNCIDX"
   else
      Out "LIB SIXNCIDX"
   endif 
endif

if LINKER == "B"
   Out    "MOD tbrowse0"
   Out    "MOD tbrowse1"
   Out    "MOD linelen"
   Out    ""

   // Blinker Dual mode
   if BLVER == "3" .and. BLMODE == "D"
      Out "SECTION INTO BRO.OVL"
   endif

   Out    "BEGINAREA"

endif

// Startup @ Rdd requests
Out       "FILE STARTUP"
if CLVER == "2"
   Out       "FILE RDDRQST"
endif

// Colors
if HICOLOR
   Out    "FILE BROCOLOR"
else
   Out    "FILE BROCOLNB"
endif

// standard libs
if CLVER == "1"
   Out    "LIB BROPL51"
   if NDX
      Out "FILE BRONDX"
      Out "LIB DBFNDX"
   endif
else
   Out    "LIB BROPL52"
   Out    "LIB CALC"
endif

// SuccessWare stuff
if CLVER == "2" .and. .not. SIX .and. .not. DBFNSX
   // not even HiPer-SIx
   Out    "FILE BRONOSUC"
endif

// SIx Driver stuff
if SIX
   if SIXENC
      Out "FILE BROSXENC"
   endif

   Out    "FILE BROSIX"

   if CLVER == "2"
      if SIXVER == "1" .and. SIXCDX .and. SIXNSX
         Out "LIB SIXLINK"
      endif

      if SIXNSX .and. .not. SIXCDX
         Out "FILE BNOSXCDX"
      endif
   endif
else
   // No SIx Driver
   Out    "FILE BRONOSIX"
endif

// Comix stuff
if CLVER == "2"
   if CMX
      // Comix 1
      Out "LIB CMX"
      Out "FILE BRONOCX3"
      if CMXINTL
         Out "FILE CMXNATIO.LIB"
      endif
   elseif CX3
      // Comix 3
      Out "LIB CMX52"
      Out "FILE BRONOCMX"
      if CMXINTL
         Out "FILE CMXINT52"
      endif
   else
      Out "FILE BRONOCMX"
      Out "FILE BRONOCX3"
      Out "FILE BNOCOMIX"
   endif
endif

//FlexFile stuff
if FLEX

   if FLEXVER == "2" .and. FLEXRDD
      // RDD
      Out "FILE BROFLRDD"
      Out "FILE BNOFLAPI"
   else
      // API
      Out "FILE BROFLAPI"
      Out "FILE BNOFLRDD"
   endif

   if FLEXVER == "2"
      if CLVER == "1"
         Out "LIB FLEX51"
      else
         Out "LIB FLEX52"
      endif
   else
      Out "LIB FLEXFILE"
   endif

else
   Out    "FILE BNOFLAPI"
   Out    "FILE BNOFLRDD"
   Out    "FILE BRNOFLEX"
endif

// Swap stuff
if LINKER == "B" .or. ( LINKER == "R" .and. OVLSWAP )
   Out    "FILE BROSWAP"
   if LINKER == "R"
      Out "LIB OVERCL"
   endif
else
   Out    "FILE BRNOSWAP"
endif

// Additional Object files?
if .not. empty( MOREOBJS )
   Out    "FILE " + trim( MOREOBJS )
endif

if LINKER == "B"

   if CLVER == "2"
      Out "ENDAREA"
      Out ""
   endif

   if BLVER == "3" .and. BLMODE $ "ED"

      // Blinker Extended/Dual
      if CLVER == "1"
         Out "SEARCH BLXCLP50"
      else
         Out "SEARCH BLXCLP52"
      endif
      // Out "SEARCH BLXRATEX"   // is probably not required

   endif

   // Clipper overlay scripts
   if CLVER == "1"
      Out "@CL501STD.LNK"
      Out "LIB EXTEND"
      Out "ENDAREA"
      Out ""
   else
      Out "@CL520MID.LNK"
   endif

endif

// Rdd overlay scripts
if LINKER == "B"

   if SIX
      if CLVER == "2" .and. SIXVER == "2"
         Out "@SIX2.LNK"
      else
         if SIXCDX
            Out "@SIXCDX.LNK"
         endif
         if SIXNSX
            Out "@SIXNSX.LNK"
         endif
      endif
   endif

   if DBFNSX
      Out "@DBFNSX.LNK"
   endif

   if CMX .or. CX3
      Out "@CMX.LNK"
   endif

   if CDX
      Out "@CDX520.LNK"
   endif

else

   // Rdd libraries
   if SIX
      if CLVER == "2" .and. SIXVER == "2"
         Out "LIB SIX2"
      else
         if SIXCDX
            Out "LIB SIXCDX"
         endif
         if SIXNSX
            Out "LIB SIXNSX"
         endif
      endif
   endif

   if DBFNSX
      Out "LIB DBFNSX"
   endif

   if CDX
      Out "LIB DBFCDX"
   endif

endif

if NTX
   Out "LIB DBFNTX"
endif

if CLVER == "2"
   if NDX
      Out "LIB DBFNDX"
   endif
   if MDX
      Out "LIB DBFMDX"
   endif
endif

// Additional Libraries?
if .not. empty( MORELIBS )
   Out    "LIB " + trim( MORELIBS )
endif

Out       ""
Out       "## End of " + LNKFILE

fClose(i)

*----------------------------------------------------------------------------
// write RDDRQST.PRG (driver requests, and custom requests (externals)
if CLVER == "2" .or. .not. empty( REQUESTS )

   if ( i := fCreate( RDDPRG, 0 ) ) > -1

      if .not. empty( REQUESTS )
         Out "external " + trim( REQUESTS )
      endif

      if CLVER == "2"

         Out "// RDD requests & default RDD selection"
         Out "// " + dtoc( date() ) + "  " + time()

         if NTX
            Out "request DBFNTX"
         endif
         if NDX
            Out "request DBFNDX"
         endif
         if MDX
            Out "request DBFMDX"
         endif
         if CDX
            Out "request DBFCDX"
         endif
         if CMX
            Out "request DBFCMX"
         endif
         if CX3
            Out "request COMIX"
         endif
         if DBFNSX
            Out "request DBFNSX"
         endif
         if SIXNTX
            Out "request SIXNTX"
         endif
         if SIXCDX
            Out "request SIXCDX"
         endif
         if SIXNSX
            Out "request SIXNSX"
         endif

         if .not. NTX
            if MDX
               cDef := "DBFMDX"
            elseif CDX
               cDef := "DBFCDX"
            elseif CX3
               cDef := "COMIX"
            elseif SIXCDX
               cDef := "SIXCDX"
            elseif SIXNSX
               cDef := "SIXNSX"
            elseif SIXNTX
               cDef := "SIXNTX"
            elseif CMX .or. DBFNSX .or. NDX //need to inherit from DBFNTX Rdd
               cDef := "DBFNTX"
            endif
            Out ""
            Out "INIT Procedure RddInit"
            Out "announce RDDSYS"
            Out "request " + cDef
            Out "RddSetDefault( '" + cDef + "' )"
            if LINKER == "E"
               Out "ExoGPInstall()"
            endif
            Out    "return"
         endif

      endif

   endif

   fClose(i)

endif

*----------------------------------------------------------------------------
// write batch file to compile RddRqst.prg & link BroPlus.lnk
if ( i := fCreate( "MAKEBRO.BAT", 0 ) ) > -1

   Out "REM " + dtoc( date() ) + "  " + time()

   if CLVER == "2" .or. .not. empty( REQUESTS )
      Out "clipper RddRqst /m/w"
   endif
   Out "clipper StartUp /m/w"

   if LINKER == "B"
      Out "Blinker @BroPlus"
   elseif LINKER == "E"
      Out "ExoSpace @BroPlus"
   else
      Out "RTLink @BroPlus"
   endif

   fClose(i)

endif

return TRUE

*============================================================================
