/*ͻ
 ۺ Author        : Graham McKechnie    (shadow)                           
 ۺ Date          : 04-08-93                                               
 ۺ Copyright     : 1993 by RCM Software (Australia)                       
 ۺ                                                                        
 Ķ
 ۺ Tweaker       : Kevin S. Gallagher (shadow)                            
 ۺ Date          : 09-29-93                                               
 ۺ Comments      : Blinker 3.00 extended/protected mode compatible        
 ۺ Tweaks        : Added parameter to allow either a left or right side   
 ۺ                 shadow to the shadow() function. If the shadow param   
 ۺ                 is not passed, the function simply returns to clipper. 
 ۺ                                                                        
 Ķ
 ۺ                                                                        
 ۺ Author        : Kevin S. Gallagher  (boxs)                             
 ۺ Date          : 12-21-93                                               
 ۺ Copyright     : Gallagher Computing (USA)                              
 ۺ Comments      : Blinker 3.00 extended/protected mode compatible        
 ۺ                                                                        
 ͼ
 */

// Compiled with MSVC v8.0  cl /c /AL /FPa /Zl /Oalt /Gh /Gs /W3
// Compiled with MSC  v6.0  cl /c /Zp /Zl /AL /Ox /Gs /FPa /W3 /nologo

#include "extend.api"
#include "gt.api"
#include "fm.api"

#define LEFT_BOT  1
#define RIGHT_BOT 2
#define TOT_PARMS 5

// make frame array one based for xbase programmers
char * BOXFRAMES[5] = {"  ","ͻȺ ","Ŀ ","͸Գ ","ķӺ "};


static void near ColorAttr( USHORT uiTop,
                            USHORT uiLeft,
                            USHORT uiBottom,
                            USHORT uiRight );


CLIPPER Box( )
{
   USHORT uiSavRow   = 0;
   USHORT uiSavCol   = 0;
   USHORT uiTop      = _parni(1);
   USHORT uiLeft     = _parni(2);
   USHORT uiBottom   = _parni(3);
   USHORT uiRight    = _parni(4);
   USHORT uiType     = _parni(5);
   BYTEP  fpColor    = _parc(6);
   int  count        = _parinfo(0);

   BYTE cSavColor[CLR_STRLEN];

   // save old position and colors
   _gtGetPos(&uiSavRow,&uiSavCol);
   _gtGetColorStr(cSavColor);
   
   if (ISNUM(5))
      {
      if (uiType >4 || uiType < 1)
         {
         uiType = 1;
         }
      }

   if (count == 6)
      {
      // color and frame specified
      _gtSetColorStr(fpColor);
      _gtBox(uiTop,uiLeft,uiBottom,uiRight,BOXFRAMES[uiType]);
      }
   else if (count == 5)
      {
      // frame specified
      _gtBox(uiTop,uiLeft,uiBottom,uiRight,BOXFRAMES[uiType]);
      }
   else if (count == 4)
      {
      // default frame
      _gtBox(uiTop,uiLeft,uiBottom,uiRight,BOXFRAMES[1]);
      }

   // restore old color and cursor position on exit...
   _gtSetPos(uiSavRow,uiSavCol);
   _gtSetColorStr(cSavColor);

}

CLIPPER Shadow( )
{
   USHORT uiTop      = _parni(1);
   USHORT uiLeft     = _parni(2);
   USHORT uiBottom   = _parni(3);
   USHORT uiRight    = _parni(4);
   USHORT uiSide     = _parni(5);
   int count         = _parinfo(0);

   if (count == TOT_PARMS)
      {
      if (uiSide == LEFT_BOT)
         {
         // left side
         ColorAttr( uiTop+1, uiLeft -1, uiBottom, uiLeft  -1 );
         // bottom
         ColorAttr( uiBottom+1, uiLeft -1, uiBottom+1, uiRight -1);
         }
      else if (uiSide == RIGHT_BOT)
         {
         ColorAttr( uiTop+1, uiRight+1, uiBottom+1, uiRight + 1 );
         ColorAttr( uiBottom+1, uiLeft +1, uiBottom+1, uiRight);
         }
      }
   _ret();
}



static void near ColorAttr ( USHORT uiTop,
                             USHORT uiLeft,
                             USHORT uiBottom,
                             USHORT uiRight )


{
   USHORT uiBufferSize;
   USHORT i;
   USHORT j;
   USHORT k;

   BYTEP scrPtr;

   // Get the size of uiBuffer and alloc memory for scrPtr
   _gtRectSize( uiTop,  uiLeft, uiBottom,  uiRight , &uiBufferSize );

   scrPtr = _xalloc( uiBufferSize );

   // Save the row or the column
   _gtSave( uiTop,  uiLeft, uiBottom,  uiRight , scrPtr );

    for ( j = uiTop; j <= uiBottom; ++j ){

       // Get the start of scrPtr
       i = ( (j - uiTop) * (uiRight - uiLeft + 1) * 2 ) + 1;

       // From left to right
       for ( k = uiLeft; k <= uiRight; ++k, i += 2 ){

          // If high intensity background and high intensity foreground
          if( scrPtr[i] & 0x0080  &&  scrPtr[i] &  0x0008 )

              // Set both bits 3 and 7 off
              scrPtr[i] &= 0x0077;   // 119

          // If only high intensity background
          else if( scrPtr[i] & 128 )

              // Set bit 7 off
              scrPtr[i] &= 0x0070;    // 112

          // Normal shadow type
          else scrPtr[i] = 0x0008;
       }

    }

    // restore the row or the column
    _gtRest( uiTop,  uiLeft, uiBottom,  uiRight , scrPtr );

    // free the memory allocated to scrPtr
    _xfree( scrPtr );
    return;
}
