/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "Class(y).ch"

CREATE CLASS Window
EXPORT:
   VAR colorMain        /* color string for user area                */
   VAR colorTitle       /* color string for title area               */
   VAR colorBorder      /* color string for border                   */
   VAR title            /* title string                              */
   VAR buttonMin        /* include minimize button?                  */
   VAR buttonMax        /* include maximize button?                  */
   VAR buttonClose      /* include close button?                     */
   VAR fillChar         /* background fill character                 */
   VAR shadow           /* use shadow?                               */
   VAR border           /* border characters, or "S"/"D"             */
   VAR minRow           /* minimum true row #                        */
   VAR minCol           /* minimum true col #                        */
   VAR maxRow           /* maximum true row #                        */
   VAR maxCol           /* maximum true col #                        */
   VAR userMove         /* can user move window?                     */
   VAR userResize       /* can user resize window?                   */
   VAR row              /* current relative row #                    */
   VAR col              /* current relative col #                    */
   VAR contents         /* savescreen of window's user area          */
   METHOD show          /* show (display) window, giving it focus    */
   METHOD hide          /* hide window, losing focus                 */
   METHOD move          /* reposition window                         */
   METHOD export        /* sends window contents to array            */
   METHOD import        /* receives contents from outside source     */
ENDCLASS

CONSTRUCTOR new(aCoords, cTitle, aColors, )
   ::file  := cFile
   ::path  := cPath
   ::error := 0                                  // 0 is no error condition
   ::how   := 0
   ::delim := CRLF
RETURN

METHOD FUNCTION open(nHow)
   DEFAULT nHow TO FO_READ
   IF File(::file)
      ::handle := fOpen(::file, nHow)
      IF ::handle == -1
         ::error := fError()
      ELSE
         ::how := nHow
      ENDIF
   ENDIF
ENDFUNCTION

METHOD FUNCTION close()
   IF ::handle != NIL
      fClose(::handle)
      ::handle := NIL
   ELSE
      ::error := FIO_NOTOPEN
   ENDIF
ENDFUNCTION


METHOD FUNCTION create()
   ::handle := fCreate(::file)
ENDFUNCTION

METHOD FUNCTION top()
   fSeek(::handle, 0, FS_SET)
ENDFUNCTION

METHOD FUNCTION bottom()
   fSeek(::handle, 0, FS_END)
ENDFUNCTION

METHOD FUNCTION posChr(nByte)
   LOCAL nRetVal
   IF nByte=NIL
      nRetVal := fSeek(::handle, 0, FS_RELATIVE)
   ELSE
      nRetVal := fSeek(::handle, nByte, FS_RELATIVE)
   ENDIF
   IF nRetVal>::fileSize()
      ::bottom()
      nRetVal := ::fileSize()
   ELSEIF nRetVal<0
      ::top()
      nRetVal := 0
   ENDIF
   RETURN nRetVal
ENDFUNCTION

METHOD FUNCTION readChar(nChr)
   LOCAL cBuffer, nBytes
   DEFAULT nChr TO 1
   cBuffer := Space(nChr)
   nBytes  := fRead(::handle, @cBuffer, nChr)
   IF nBytes!=nChr
      ::error := FIO_BADREAD
   ENDIF
   RETURN cBuffer
ENDFUNCTION

METHOD FUNCTION writeChar(cChr)
   IF cChr!=NIL
      fWrite(::handle, cChr)
   ELSE
      ::error := FIO_BADCHR
   ENDIF
ENDFUNCTION

METHOD FUNCTION fileSize()
   LOCAL nBytes, nPos
   nPos   := fSeek(::handle, 0, FS_RELATIVE)
   nBytes := fSeek(::handle, 0, FS_END)
   fSeek(::handle, nPos, FS_SET)
   RETURN nBytes
ENDFUNCTION
