/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

FUNCTION vScroll(nRow1, nCol1, nRow2, nCol2, cDirection, nDistance)
   LOCAL aDestination[nRow2-nRow1+1], aLine[nRow2-nRow1+1], cScreen, nCtr
   LOCAL cSqueezed, nCounter
   cScreen := SaveScreen(nRow1, nCol1, nRow2, nCol2)
   IF pCount()<5
      cDirection := 'U'
   ENDIF
   IF pCount()<6
      nDistance := 1
   ENDIF
   cDirection := Upper(cDirection)
   IF cDirection$'UD'
      IF nRow2-nRow1+1<nDistance
         nDistance := nRow2-nRow1+1
      ENDIF
      Scroll(nRow1, nCol1, nRow2, nCol2, nDistance*iif(cDirection="D", -1, 1))
      RETURN NIL
   ENDIF
   IF nCol2-nCol1+1<nDistance
      nDistance := nCol2-nCol1+1
   ENDIF
   cSqueezed := sSqueeze(cScreen, 1, 2)
   FOR nCtr := 1 TO nRow2-nRow1+1
      aLine[nCtr] := sParse(@cSqueezed, nCol2-nCol1+1)
   NEXT
   nCounter := 1
   DO CASE
   CASE cDirection='L'
      FOR nCtr := 1 TO Len(aDestination)
         aDestination[nCtr] := SubStr(aLine[nCtr], nDistance+1)+;
               Space(nDistance)
      NEXT
   CASE cDirection='R'
      FOR nCtr := 1 TO Len(aDestination)
         aDestination[nCtr] := Space(nDistance)+Left(aLine[nCtr],;
               Len(aLine[nCtr])-nDistance)
      NEXT
   ENDCASE
   cSqueezed := ''
   FOR nCtr := 1 TO Len(aDestination)
      cSqueezed += aDestination[nCtr]
   NEXT
   cScreen := sUnSqueeze(cSqueezed, cScreen, 1, 2)
   RestScreen(nRow1, nCol1, nRow2, nCol2, cScreen)
ENDFUNCTION
