/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

/* THIS CODE IS MODIFIED CODE - ORIGINAL CODE COPYRIGHT (C) NANTUCKET CORP */

#include "beckner.inc"
#include "inkey.ch"
#include "set.ch"
#include "getexit.ch"
#include "setcurs.ch"
#define K_PLUS       43
#define K_MINUS      45
#define SCORE_ROW     0
#define SCORE_COL    60
#define K_UNDO K_CTRL_U

FUNCTION vGet(oGet)
   LOCAL nMsgRow := Set(_SET_MESSAGE), nElement, lMessage := .n., lDate
   LOCAL aCargoScan, aCargoMsg, aIdle, nKey, aMemoCoords, lIsMemo, cMemo
   LOCAL bOldAltR := SetKey(K_ALT_R, {||oGet:varPut(oRevCase(oGet:varGet()))})
   LOCAL nCursor := Set(_SET_CURSOR, SC_NORMAL)
   aCargoScan := a1From2(oGet:cargo, 1)
   aCargoMsg  := a1From2(oGet:cargo, 2)
   lDate := (oGet:type="D" .and. aScan(aCargoScan, "D")>0)
   IF !GetPreValidate(oGet)
      SetKey(K_ALT_R, bOldAltR)
      Set(_SET_CURSOR, nCursor)
      RETURN NIL
   ENDIF
   aIdle    := iReadIdle()
   nElement := aScan(aCargoScan, "M")
   IF nElement>0
      lMessage := .y.
      vCursSave()
      vSave(nMsgRow)
      vCenter(MaxCol()+1, nMsgRow, 0, SubStr(aCargoMsg[nElement], 2))
      vCursRest()
   ENDIF
   lIsMemo := (oGet:type="M")
   iif(lIsMemo, (cMemo := oGet:varGet(), oGet:varPut("<memo>")),)
   oGet:SetFocus()
   iif((nElement := aScan(aCargoScan, "Z"))>0,;
   aMemoCoords := aCargoMsg[nElement],)
   nElement    := aScan(aCargoScan, "E")
   IF aMemoCoords!=NIL
      vSave(aMemoCoords[1]-1, aMemoCoords[2]-1, aMemoCoords[3]+1,;
            aMemoCoords[4]+1)
      @ aMemoCoords[1]-1, aMemoCoords[2]-1 TO aMemoCoords[3]+1,;
            aMemoCoords[4]+1 DOUBLE
      oGet:picture := ""
      Eval(oGet:block, MemoEdit(cMemo, aMemoCoords[1], aMemoCoords[2],;
            aMemoCoords[3], aMemoCoords[4], .y.))
      vRestore()
      oGet:exitState := GE_ENTER
   ELSE
      WHILE oGet:exitState==GE_NOEXIT
         IF oGet:typeOut
            oGet:exitState := GE_ENTER
            EXIT
         ENDIF
         Eval(aIdle[1])
         iif(pSetSaver()[1]>0, tElapsedS(), )
         WHILE oGet:exitState==GE_NOEXIT
            nKey := Inkey(aIdle[2])
            Eval(aIdle[1])
            IF nKey=0
               iif(pSetSaver()[1]>0, iSSCheck(tElapsedC()), )
               LOOP
            ENDIF
            iif(pSetSaver()[1]>0, tElapsedO(), )
            GetApplyKey(oGet, nKey, lDate)
            IF nElement>0 .and. Val(SubStr(aCargoMsg[nElement], 2))=LastKey()
               oGet:exitState := GE_WRITE
            ENDIF
            iif(pSetSaver()[1]>0, tElapsedS(), )
         ENDWHILE
         iif(pSetSaver()[1]>0, tElapsedO(), )
         iif(!GetPostValidate(oGet), oGet:exitState := GE_NOEXIT,)
      ENDWHILE
   ENDIF
   iReadIdle({||.y.}, 0) /* Turn off READ IDLE */
   IF lMessage
      vRestore()
   ENDIF
   oGet:KillFocus()
   Set(_SET_CURSOR, nCursor)
   SetKey(K_ALT_R, bOldAltR)
ENDFUNCTION

STATIC FUNCTION GetApplyKey(oGet, nKey, lDate)
   LOCAL cKey, bKeyBlock
   IF (bKeyBlock := SetKey(nKey))!=NIL
      GetDoSetKey(bKeyBlock, oGet)
      RETURN NIL
   ENDIF
   DO CASE
   CASE lDate .and. nKey=K_PLUS
      oGet:varPut(oGet:varGet()+1)
      oGet:updateBuffer()
   CASE lDate .and. nKey=K_MINUS
      oGet:varPut(oGet:varGet()-1)
      oGet:updateBuffer()
   CASE nKey=K_UP
      oGet:exitState := GE_UP
   CASE nKey=K_SH_TAB
      oGet:exitState := GE_UP
   CASE nKey=K_DOWN
      oGet:exitState := GE_DOWN
   CASE nKey=K_TAB
      oGet:exitState := GE_DOWN
   CASE nKey=K_ENTER
      oGet:exitState := GE_ENTER
   CASE nKey=K_ESC
      IF Set(_SET_ESCAPE)
         oGet:undo()
      oGet:exitState := GE_ESCAPE
   ENDIF
   CASE nKey=K_PGUP
      oGet:exitState := GE_WRITE
   CASE nKey=K_PGDN
      oGet:exitState := GE_WRITE
   CASE nKey=K_CTRL_HOME
      oGet:exitState := GE_TOP
#IFdef CTRL_END_SPECIAL
   CASE nKey=K_CTRL_END
      oGet:exitState := GE_BOTTOM
#else
   CASE nKey=K_CTRL_W
      oGet:exitState := GE_WRITE
#endIF
   CASE nKey=K_INS
      Set(_SET_INSERT, !Set(_SET_INSERT))
      ShowScoreboard()
   CASE nKey=K_UNDO
      oGet:Undo()
   CASE nKey=K_HOME
      oGet:Home()
   CASE nKey=K_END
      oGet:End()
   CASE nKey=K_RIGHT
      oGet:Right()
   CASE nKey=K_LEFT
      oGet:Left()
   CASE nKey=K_CTRL_RIGHT
      oGet:WordRight()
   CASE nKey=K_CTRL_LEFT
      oGet:WordLeft()
   CASE nKey=K_BS
      oGet:BackSpace()
   CASE nKey=K_DEL
      oGet:Delete()
   CASE nKey=K_CTRL_T
      oGet:DelWordRight()
   CASE nKey=K_CTRL_Y
      oGet:DelEnd()
   CASE nKey=K_CTRL_BS
      oGet:DelWordLeft()
   OTHERWISE
      IF nKey>0 .and. nKey<=255
         cKey := Chr(nKey)
         IF (oGet:type="N" .and. (cKey="." .or. cKey=","))
            oGet:ToDecPos()
         ELSE
            IF Set(_SET_INSERT)
               oGet:Insert(cKey)
            ELSE
               oGet:Overstrike(cKey)
            ENDIF
            IF (oGet:typeOut .and. !Set(_SET_CONFIRM))
               IF Set(_SET_BELL)
                  ?? Chr(7)
               ENDIF
               oGet:exitState := GE_ENTER
            ENDIF
         ENDIF
      ENDIF
   ENDCASE
ENDFUNCTION

STATIC FUNCTION ShowScoreboard()
   LOCAL nRow, nCol
   IF Set(_SET_SCOREBOARD)
      vCursSave()
      SetPos(SCORE_ROW, SCORE_COL)
      DispOut(if(Set(_SET_INSERT), "Ins", "   "))
      vCursRest()
   ENDIF
ENDFUNCTION

FUNCTION oRevCase(cString)
   LOCAL nCtr, cReturn := "", nChar
   IF ValType(cString)!="C"
		 RETURN cString
   ENDIF
   FOR nCtr := 1 TO Len(cString)
      IF (nChar := Asc(SubStr(cString, nCtr, 1)))>64 .and. nChar<91
         cReturn += Chr(nChar+32)
      ELSEIF nChar>96 .and. nChar<123
         cReturn += Chr(nChar-32)
      ELSE
         cReturn += Chr(nChar)
      ENDIF
   NEXT
	RETURN cReturn
ENDFUNCTION


