/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "setcurs.ch"
#include "inkey.ch"

FUNCTION vCreateScreen(bIdle, nMinRow, nMinCol, nMaxRow, nMaxCol)
   LOCAL nCursor, nKey
   nCursor := SetCursor(SC_SPECIAL1)
   DEFAULT nMinRow TO 0, nMinCol TO 0, nMaxRow TO MaxRow(),;
         nMaxCol TO MaxCol()
   WHILE LOOPING
      nKey := InKey()
      iif(nKey=0 .and. bIdle!=NIL, Eval(bIdle),)
      IF nKey=0
         LOOP
      ENDIF
      DO CASE
      CASE nKey=K_RIGHT
         iif(Col()=nMaxCol, iif(Row()=nMaxRow, SetPos(nMinRow, nMinCol),;
               SetPos(Row()+1, nMinCol)), SetPos(Row(), Col()+1))
      CASE nKey=K_LEFT
         iif(Col()=nMinCol, iif(Row()=nMinRow, SetPos(nMaxRow, nMaxCol),;
               SetPos(Row()-1, nMaxCol)), SetPos(Row(), Col()-1))
      CASE nKey=K_UP
         iif(Row()=nMinRow, iif(Col()=nMinCol, SetPos(nMaxRow, nMaxCol),;
               SetPos(nMaxRow, Col()-1)), SetPos(Row()-1, Col()))
      CASE nKey=K_DOWN
         iif(Row()=nMaxRow, iif(Col()=nMaxCol, SetPos(nMinRow, nMinCol),;
               SetPos(nMinRow, Col()+1)), SetPos(Row()+1, Col()))
      CASE nKey=K_BS
         IF Col()=nMinCol
            pSoundError()
         ELSE
            SetPos(Row(), Col()-1)
            DevOut(" ")
            SetPos(Row(), Col()-1)
         ENDIF
      CASE nKey=K_DEL
         vCursSave()
         DevOut(" ")
         vCursRest()
      CASE nKey=K_INS
         vSave(Row(), Col(), Row(), nMaxCol-1)
         vRestore(, Row(), Col()+1, Row(), nMaxCol)
         KEYBOARD Chr(K_DEL)
         LOOP
      CASE nKey=K_ALT_N
         CLS
      CASE nKey=K_ESC
         EXIT
      CASE nKey=K_CTRL_W .or. nKey=K_F9
         EXIT
      OTHERWISE
         DevOut(Chr(nKey))
      ENDCASE
   ENDWHILE
ENDFUNCTION
