/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

MEMVAR ulength, fld_name, fld_data, cfieldtyp, cmatch, lsortlist, nrecsleft
MEMVAR lfoundrec, cfieldname, crecnums, nnumfound

FUNCTION rFullLocate()
/* THIS FILE IS NOT SET TO BECKNERVISION'S CLIPPER 5 STANDARD */
   LOCAL cFieldName, cData, cRelationship, lCreateIndex, cFieldType, cTempFile
   LOCAL cKeySave, lUseList, cFileName, aCoordinates, GetList := {}
   LOCAL cTemp := "", cFieldLength, nFieldLength
   eSave()
   cFieldName    := Space(22)
   cData         := Space(300)
   cRelationship := "= "
   cFileName     := Space(64)
   aCoordinates  := vWindow(6, 55, .y., 'RECORD LOCATOR')
   @ aCoordinate[1], aCoordinate[2] SAY 'File Name .................';
         GET cFileName PICTURE '@!S22'
   @ Row()+1, aCoordinate[2] SAY 'Field Name ................';
         GET cFieldName PICTURE '@!'
   @ Row()+1, aCoordinate[2] SAY 'Data (*=equality list) ....';
         GET cData PICTURE '@S22'
   @ Row()+1, aCoordinate[2] SAY 'Relationship ..............';
         GET cRelationship VALID pInSet(cRelationship,;
         "= ,!=,==,$ ,<>,# ,> ,< ,>=,<=")
   READ
   IF !File(fExtNew((cFileName := Trim(cFileName)), "DBF"))
      eRestore()
      RETURN .n.
   ENDIF
   fShare(cFileName, 'File2Check')
   uLength      := Eval(FieldBlock(cFieldName))
   cFieldName   := Trim(cFieldName)
   cFieldType   := ValType(uLength)
   nFieldLength := iif(cFieldType$"MC", Len(uLength),;
         iif(cFieldTyp="N", Len(Str(uLength)),;
         iif(cFieldTyp="D", 8, 1)))
   cFieldLength := lTrim(Str(nFieldLength, 4))
   IF (lUseList := (cData := Trim(cData))=="*")
      cTempFile := fUnique()
   cTemp := cTempFile+'/FLD_DATA/'+cFieldType+'/'+;
         iif(cFieldType$"CM", cFieldLength, "")
   cTemp += iif(cFieldType="N", cFieldLength+'/'+;
         lTrim(Str(fDecimals(uLength))), "")
   fCreateDBF(cTemp)
   CLS
   @ 1, 0 SAY 'Equality list FOR '+fld_name+', enter data:'
   SetPos(2, 0)
   fNoShare(cTempFile, 'data')
   WHILE LOOPING
      fAddRecord()
      IF Row()=MaxRow()
         Scroll(2, 0, MaxRow(), MaxCol(), 1)
         IF cFieldType='C'
            IF nFieldLength>80
               @ MaxRow(), 0 GET fld_data PICTURE '@S80'
            ELSE
               @ MaxRow(), 0 GET fld_data
            ENDIF
         ELSE
            @ 24, 0 GET fld_data
         ENDIF
      ELSE
         IF cFieldType='C'
            IF nFieldLength>80
               @ Row()+1, 0 GET fld_data PICTURE '@S80'
            ELSE
               @ Row()+1, 0 GET fld_data
            ENDIF
         ELSE
            @ Row()+1, 0 GET fld_data
         ENDIF
      ENDIF
      READ
      IF Empty(fld_data)
         EXIT
      ENDIF
   ENDWHILE
   DELETE
   @ 2, 0 CLEAR TO MaxRow(), MaxCol()
   @ 3, 0 SAY 'Sort list (Y/N)?' GET lSortList PICTURE 'Y'
   @ 4, 0 SAY 'E/xact data match or S/ubstring match?' GET cMatch PICTURE '@!A';
         VALID cMatch$'ES'
   READ
   IF lSortList
      INDEX ON fld_data TO (cTempFile)
   ENDIF
ENDIF
cData := Trim(cData)
CLS
@ 1, 0 SAY 'Creating file BECKNER$.DBF.  This is a time consuming process.'
@ 2, 0 SAY 'Press <ESC> to abort.  Upon completion, all records found will be displayed.'
SELECT File2Check
@ 3, 0 SAY 'Records remaining to search:'
@ 4, 4 SAY 'Records found in search:'
@ 6, 0 SAY 'Pass 1 of 2'
nRecsLeft=lastrec()
COPY STRUCTURE to beckner$
fNoShare('beckner$','outfile')
SELECT File2Check
GO TOP
WHILE !eof()
   lFoundRec := .n.
   IF inkey()=27
      eRestore()
      RETURN NIL
ENDIF
@ 3, 30 say --nRecsLeft picture '999,999,999'
IF !lUseList
   IF cRelationship='$'
      lFoundRec := (cData$eval(fieldblock(cFieldName)))
   ELSE
      lFoundRec := pAnalyze(eval(fieldblock(cFieldName)), cRelationship,;
      cData)
   ENDIF
ELSE
   SELECT Data
   GO TOP
   WHILE !eof()
      SELECT File2Check
      IF cMatch='E'
         lFoundRec := pAnalyze(eval(fieldblock(cFieldName)), "=",;
         trim(Data->fld_data))
      ELSE
         lFoundRec := (trim(Data->fld_data)$eval(fieldblock(cFieldName)))
      ENDIF
      IF lFoundRec
         EXIT
      ENDIF
      SELECT Data
      SKIP
   ENDWHILE
ENDIF
IF lFoundRec
   cRecNums := cRecNums+'/'+str(recno(),9)
   @ 4,30 say ++nNumFound picture '999,999,999'
ENDIF
SKIP
ENDWHILE
SELECT File2Check
CLOSE
SELECT OutFile
IF !empty(cRecNums)
   @ 6,5 say '2'
   APPEND from (cFileName) FOR str(recno(),9)$cRecNums
ENDIF
IF lastrec()>0
   GO TOP
   browse(1, 0, maxrow(), maxcol())
ELSE
   @ 1,0 say 'NO RECORDS FOUND!  Press any key to continue...'
   inkey(0)
ENDIF
CLOSE
IF lUseList
   SELECT Data
   CLOSE
ENDIF
eRestore()
RETURN NIL

