/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "set.ch"
#include "inkey.ch"

/* if cnLength is character, it may be:
   "D"   default
   "L"   letter
   "G"   legal
   "E"   executive
   "A"   A4
   "B"   B5
   You should also specify nLPI if it isn't 6
*/

FUNCTION plPageLength(cnLength, nLPI)
   LOCAL lSetPrint := Set(_SET_PRINTER, .y.)
   LOCAL lSetConsole := Set(_SET_CONSOLE, .n.)
   LOCAL aLength := {{0, 66, 84, 63, 70, 60}, {0, 88, 112, 84, 93, 80}}
   DEFAULT cnLength TO 66
   DEFAULT nLPI TO 6
   ?? Chr(K_ESC)+"&l"
   IF ValType(cnLength)="N"
      ?? sMake(cnLength)
   ELSE
      IF nLPI=6
         ?? sMake(aLength[1, At(Upper(cnLength), "DLGEAB")])
      ELSE
         ?? sMake(aLength[2, At(Upper(cnLength), "DLGEAB")])
      ENDIF
   ENDIF
   Set(_SET_PRINTER, lSetPrint)
   Set(_SET_CONSOLE, lSetConsole)
ENDFUNCTION

