/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

FUNCTION pLineChk(cFile)
   LOCAL nQuote, cQuoteChar, cValidQuote, cEndQuote, nLen, nCtr, cChar
   LOCAL cLine := "", cValidDelim := "({", cEndDelim := ")}", nDepth := 0
   LOCAL cDelimList := ""
   cValidQuote := "'["
   cValidQuote += ["]
   cEndQuote   := "']"
   cEndQuote   += ["]
   aEval(aFromFile(cFile), {|c| cLine += " "+lTrim(c),;
         iif(Right(cLine, 1)=";", cLine := Left(cLine, Len(cLine)-1),)})
   nLen        := Len(cLine)
   SET PRINTER ON
   CLS
   ? cLine
   ?
   FOR nCtr := 1 TO nLen
      ? (cChar := SubStr(cLine, nCtr, 1))
      IF cChar$cValidQuote
         cQuoteChar := SubStr(cEndQuote, At(cChar, cValidQuote), 1)
         WHILE ++nCtr<=nLen
            ?? (cChar := SubStr(cLine, nCtr, 1))
            IF cChar=cQuoteChar
               EXIT
            ENDIF
         ENDWHILE
      ENDIF
      IF cChar$cValidDelim
         cDelimList += cChar
         ?? " <--- Level "+sMake(++nDepth)
      ENDIF
      IF cChar$cEndDelim
         IF At(cChar, cEndDelim)!=At(Right(cDelimList, 1), cValidDelim)
            ?? " *** ERROR improper end delimiter ***"
         ELSEIF nDepth=0
            ?? " *** ERROR no more delimiters to match with ***"
         ELSE
            cDelimList := Left(cDelimList, Len(cDelimList)-1)
            ?? " ---> Level "+sMake(nDepth--)
         ENDIF
      ENDIF
   NEXT
ENDFUNCTION
