/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

FUNCTION mSplit2Sngl(nAmtFin, nNumPmts, dAcquired, nSplitAmt, nBeforeRate,;
      nAfterRate, lGetPmt, nPrecision)
   LOCAL nTestPmt, nTestAPR, nBreak, cCheck, dOld, nNumDays
   LOCAL nMonthRate, nAmount, nCtr, dTest, aPmts := {}
   asize(aPmts, nNumPmts)
   IF pcount()<8
      nPrecision := 7
   ENDIF
   IF pCount()<7
      lGetPmt := .n.
   ENDIF
   IF nBeforeRate>1
      nBeforeRate := Round(nBeforeRate/100.0000, nPrecision)
   ENDIF
   IF nAfterRate>1
      nAfterRate := Round(nAfterRate/100.0000, nPrecision)
   ENDIF
   IF nSplitAmt>=nAmtFin
      RETURN iif(lGetPmt, mAmortPmt(nAmtFin, nBeforeRate, nNumPmts),;
            nBeforeRate)
   ENDIF
   nTestAPR := nAfterRate
   nTestPmt := mAmortSched(nAmtFin, nTestAPR, nNumPmts)
   nBreak   := 4
   WHILE LOOPING
      dTest    := dAcquired
      nTestPmt := nTestPmt+nBreak
      nTestAPR := mAPR(nAmtFin, nTestPmt, nNumPmts)
      nAmount  := nAmtFin
      FOR nCtr := 1 TO nNumPmts
         dOld       := dTest
         dTest      := dSame(dOld)
         nNumDays   := dTest-dOld
         nMonthRate := nSplitAmt*(nBeforeRate/365)*nNumDays+;
               (nAmount-nSplitAmt)*nNumDays*(nAfterRate/365)
         nAmount    := nAmount-nTestPmt+nMonthRate
      NEXT
      IF nAmount>0
         LOOP
      ENDIF
      IF nBreak=4
         nTestPmt := nTestPmt-nBreak
         nBreak   := 2
      ELSEIF nBreak=2
         nTestPmt := nTestPmt-nBreak
         nBreak   := 1
      ELSEIF nBreak=1
         nTestPmt := nTestPmt-nBreak
         nBreak   := .5
      ELSEIF nBreak=.5
         nTestPmt := nTestPmt-nBreak
         nBreak   := .1
      ELSEIF nBreak=.1
         nTestPmt := nTestPmt-nBreak
         nBreak   := .05
      ELSEIF nBreak=.05
         nTestPmt := nTestPmt-nBreak
         nBreak   := .01
      ELSE
         EXIT
      ENDIF
   ENDWHILE
   RETURN iif(lGetPmt, nTestPmt, mAPR(nAmtFin, nTestPmt, nNumPmts))
ENDFUNCTION
