/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

FUNCTION mDollarWord(nAmount)
   LOCAL lNeedComma := .n., cAmount, cOut := '~~~', lWorking := .n.
   IF nAmount>999999999.99 .or. nAmount<=0
      RETURN '**invalid**'
   ENDIF
   cAmount := Str(nAmount, 12, 2)
   IF Val(Left(cAmount, 1))>0
      cOut += mDigitWord(Val(Left(cAmount, 1)))+' hundred'
      lWorking := lNeedComma := .y.
   ENDIF
   IF Val(Substr(cAmount, 2, 2))>0
      iif(lWorking, cOut += " ", lWorking := .y.)
      cOut += cOut+mDigitWord(Val(SubStr(cAmount, 2, 2)))+' million'
   ENDIF
   IF Val(SubStr(cAmount, 4, 1))>0
      iif(lWorking, cOut += ", ", lWorking := .y.)
      lNeedComma := .n.
      cOut += mDigitWord(Val(SubStr(cAmount, 4, 1)))+' hundred'
   ENDIF
   IF Val(SubStr(cAmount, 5, 2))>0
      iif(lWorking, cOut += iif(lNeedComma, ", ", " "), lWorking := .y.)
      lNeedComma := .n.
      cOut += mDigitWord(Val(SubStr(cAmount, 5, 2)))+' thousand'
   ENDIF
   IF Val(SubStr(cAmount, 7, 1))>0
      iif(lWorking, cOut += ", ", lWorking := .y.)
      lNeedComma := .n.
      cOut += mDigitWord(Val(SubStr(cAmount, 7, 1)))+' hundred'
   ENDIF
   iif(lWorking, cOut += " ",)
   cOut += mDigitWord(Val(SubStr(cAmount, 8, 2)))+' and '+;
         Str((nAmount-Round(nAmount-.5, 0))*100, 2)+'/100~~~'
   RETURN iif('zero and'$cOut .and. lWorking, Stuff(cOut,;
         At('zero and', cOut), 5, ""), cOut)
ENDFUNCTION
