/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Sets the Beckner Library S'87 compatibility switch
//
// Syntax:
//    iShare([<lCompat>]) -> lSetting
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    lCompat     .y. to set as compatible with Beckner Library S'87
//
// Returns:
//    lSetting    Current switch setting
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL cFile1 := "Test1/Name/C/25"
//       LOCAL cFile2 := "Test2/Name/C/25"
//       fCreateDbf(cFile1)         /* create 1st test dbf        */
//       fCreateDbf(cFile2)         /* create 2nd test dbf        */
//       iShare(.y.)                /* set compatibility switch   */
//       fShare("Test1")            /* open 1st test file         */
//       fShare("Test2")            /* open 2nd test file         */
//       ? Select("Test1")          /* 0, Test2 is only open file */
//       ? Select("Test2")          /* 1, Test2 is open           */
//       CLOSE DATABASES            /* closes all open work areas */
//       iShare(.n.)                /* reset compatibility switch */
//       fShare("Test1")            /* open 1st test file         */
//       fShare("Test2")            /* open 2nd test file         */
//       ? Select("Test1")          /* 1, both are open           */
//       ? Select("Test2")          /* 2, both are open           */
//       CLOSE DATABASES            /* closes all open work areas */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Sets, resets or returns the setting of the Beckner Library S'87
//    compatibility switch.  Setting this switch will cause the fShare()
//    and fNoShare() functions to not select a new work area before opening
//    the file.  Resetting this switch (the default) causes these functions
//    to open the files in new work areas.
//
// See Also:
//    fShare()
//    fNoShare()
//
// Category:
//    Internal Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION iShare(lOldWay)
   STATIC lUseOldWay := .n.
   IF lOldWay=NIL
      RETURN lUseOldWay
   ENDIF
   RETURN (lUseOldWay := lOldWay)
ENDFUNCTION
