/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

FUNCTION iElapse(nParm, nCurrentTimer)
   STATIC aTime := {}, aStop := {}
   LOCAL nTime
   DEFAULT nCurrentTimer TO Len(aTime)
   nTime := Seconds()
   DO CASE
   CASE nParm=1
      aAdd(aTime, Seconds())
      aAdd(aStop, 0)
      RETURN Len(aTime)
   CASE nParm=2
      RETURN iif(nTime>=aTime[nCurrentTimer], nTime-aTime[nCurrentTimer],;
            nTime+86400-aTime[nCurrentTimer])
   CASE nParm=3
      aTime[nCurrentTimer] := Seconds()-aStop[nCurrentTimer]
      RETURN NIL
   CASE nParm=4
      aStop[nCurrentTimer] := iif(nTime>=aTime[nCurrentTimer],;
         nTime-aTime[nCurrentTimer], nTime+86400-aTime[nCurrentTimer])
      RETURN aStop[nCurrentTimer]
   CASE nParm=5
      aTime[nCurrentTimer] := aStop[nCurrentTimer] := NIL
      aPack(aTime, .y.)
      aPack(aStop, .y.)
      RETURN NIL
   ENDCASE
ENDFUNCTION

/*
 1.02 02.05.93 Added aPack(aStop, .y.) to eliminate bound error
*/
