/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

FUNCTION fZip2City(cZip2Find)
   LOCAL aCityState[2], aCoordinates, GetList := {}, lInUse, nCurSel
   FIELD cZipCode, cCity, cState IN ZipCodes
   cZip2Find := Left(cZip2Find, 5)
   IF Empty(cZip2Find)
      RETURN {"", ""}
   ENDIF
   nCurSel  := Select()
   lInUse   := (Select("ZipCodes")>0)
   IF !lInUse
      SELECT 0
      iif(!File("ZIPCODES.DBF"),;
            fCreateDBF('ZIPCODES/CZIPCODE/C/5/CCITY/C/25/CSTATE/C/2'),)
      fShare('ZIPCODES')
   ENDIF
   IF !File('ZIPCODES.NTX')
      ZipCodes->(dbCreateIndex("ZipCodes", "cZipCode", {||cZipCode}))
   ELSEIF !lInUse
      SET INDEX TO zipcodes
   ENDIF
   ZipCodes->(dbSeek(cZip2Find))
   IF ZipCodes->(Found())
      aCityState := {Trim(ZipCodes->cCity), ZipCodes->cState}
   ELSE
      vSave()
      DispBegin()
      aCoordinates := vWindow(2, 32, .y., 'NEED CITY & STATE')
      ZipCodes->(fAddRecord())
      ZipCodes->cZipCode := cZip2Find
      @ aCoordinates[1], aCoordinates[2] SAY ' City:' GET ZipCodes->cCity;
            PICTURE '!XXXXXXXXXXXXXXXXXXXX'
      @ Row()+1, aCoordinates[2] SAY 'State:' GET ZipCodes->cState PICTURE '@!A';
            VALID sValidState(ZipCodes->cState)
      DispEnd()
      READ
      vRestore()
      IF Empty(ZipCodes->cCity)
         ZipCodes->(dbDelete())
         ZipCodes->(dbUnlock())
         iif(lInUse, (ZipCodes->(dbCloseArea()), dbSelectArea(nCurSel)),)
         SELECT (nCurSel)
         RETURN {"", ""}
      ENDIF
      ZipCodes->(dbUnlock())
      aCityState := {Trim(ZipCodes->cCity), ZipCodes->cState}
   ENDIF
   iif(lInUse, ZipCodes->(dbCloseArea()),)
   SELECT (nCurSel)
   RETURN aCityState
ENDFUNCTION
