/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#include "fileio.ch"

////////////////
////////////////
//
// Purpose:
//    Writes a line to a text file
//
// Syntax:
//    fReadLine(<cnFile>, [<cLine>]) -> NIL
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    cnFile      File handle of text file or file name
//
// Returns:
//    NIL
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL nTest
//       nTest := CreateText()
//       ? fReadLine(nTest)      /* "This is line 1." */
//       fClose(nTest)
//    ENDFUNCTION
//
//    #include "fileio.ch"
//    STATIC FUNCTION CreateText()
//       LOCAL nHandle := fCreate("testtest.txt")
//       fWriteLine(nHandle, "This is line 1.")
//       fWriteLine(nHandle, "This is line 2.")
//       fWriteLine(nHandle, "This is line 3.")
//       fSeek(nHandle, 0, FS_SET)     /* Set beginning of file */
//       RETURN nHandle
//    ENDFUNCTION
//
// Files:
//    (<cnFile>)
//
// Description:
//    Writes a line to a text file.  <cnFile> is a file name if the file has
//    not been opened, otherwise it is the file handle.  If a file name is
//    passed, the the line is written at the end of the file, otherwise it is
//    written at the current byte pointer.  Lines are written with a carriage-
//    return/line-feed sequence at the end of the line.
//
// See Also:
//    fWriteLine()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fWriteLine(cnFile, cLine)
   LOCAL nFile, lOpenHere
   DEFAULT cLine TO ""
   nFile := iif(lOpenHere := (ValType(cnFile)!="N"),;
         fOpen(cnFile, FO_WRITE), cnFile)
   iif(lOpenHere, fSeek(nFile, 0, FS_END),)
   fWrite(nFile, cLine+CRLF)
   iif(lOpenHere, fClose(nFile),)
ENDFUNCTION
