/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Reads a LBL file into an array
//
// Syntax:
//    fReadFrm(<cFile>) -> aReport
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cFile       File name
//
// Returns:
//    aReport     Label parameters
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL cFile    := "Test", aCheck, aLen := 7, nCtr
//
//       LOCAL cLine1 := "sConvertName(Name)"
//       LOCAL cLine2 := "iif(Over21, [Old enough], [Too young])"
//       LOCAL cLine3 := "Transform(Balance, [$9,999,999.99])"
//
//       LOCAL aReport  := {"comments",      /* comments                   */;
//                5,                         /* lines per label            */;
//                35,                        /* characters per line        */;
//                0,                         /* left margin                */;
//                1,                         /* lines between labels       */;
//                0,                         /* spaces between labels      */;
//                1,                         /* # labels across            */;
//                aLine1,                    /* Line 1 definition          */;
//                aLine2,                    /* Line 2 definition          */;
//                aLine3,                    /* Line 3 definition          */}
//
//       CreateTest()
//       fCreateLbl(cFile, aReport)
//       LABEL FORM Test TO PRINTER NOCONSOLE
//       aCheck := aReadLbl(cFile)
//       FOR nCtr := 1 TO aLen
//          ? aReport[nCtr]=aCheck[nCtr]     /* .t. */
//       NEXT
//       CLOSE Test
//    ENDFUNCTION
//
//    #include "alias.ch"
//    STATIC FUNCTION CreateTest()
//       fCreateDbf("Test/Name/C/32/Balance/N/12/2/Date/D/Over21/L/Notes/M")
//       USE Test NEW EXCLUSIVE
//       ADDRECORD ALIAS Test
//       Test->Name    := "Abbott, Jake"
//       Test->Balance := 0.00
//       Test->Date    := CtoD("9/26/94")
//       Test->Over21  := .y.
//       Test->Notes   := ""
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, John Wm"
//       Test->Balance := 15000.00
//       Test->Date    := CtoD("9/26/94")
//       Test->Over21  := .y.
//       Test->Notes   := "These are notes!"
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, Elizabeth Anne"
//       Test->Balance := 0.58
//       Test->Date    := CtoD("12/18/96")
//       Test->Over21  := .n.
//       Test->Notes   := ""
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, Joseph Alan"
//       Test->Balance := 1.68
//       Test->Date    := CtoD("6/10/98")
//       Test->Over21  := .n.
//       Test->Notes   := "These are too!"
//       ADDRECORD ALIAS Test
//       Test->Name    := "Zumundi, Beavis"
//       Test->Balance := 123.45
//       Test->Date    := CtoD("")
//       Test->Over21  := .y.
//       Test->Notes   := ""
//       GO TOP
//    ENDFUNCTION
//
// Files:
//    created frm
//
// Description:
//    Reads an LBL definition from an LBL file.  The contents of the array
//    are defined in the example above.
//
// See Also:
//    fCreateLbl()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fReadLBL(cFilename)
   LOCAL nFormFile, aLabel := {}, cLabel := Space(1034), nCtr
   nFormFile := fOpen(fExtNew(Trim(cFilename), "LBL"))
   fRead(nFormFile, @cLabel, 1034)
   sParse(@cLabel, 1)
   aAdd(aLabel, sParse(@cLabel, 60))
   aAdd(aLabel, pWord2Val(sParse(@cLabel, 2)))
   aAdd(aLabel, pWord2Val(sParse(@cLabel, 2)))
   aAdd(aLabel, pWord2Val(sParse(@cLabel, 2)))
   aAdd(aLabel, pWord2Val(sParse(@cLabel, 2)))
   aAdd(aLabel, pWord2Val(sParse(@cLabel, 2)))
   aAdd(aLabel, pWord2Val(sParse(@cLabel, 2)))
   FOR nCtr := 1 to aLabel[2]
      aAdd(aLabel, sParse(@cLabel, 60))
   NEXT
   fClose(nFormFile)
   RETURN aLabel
ENDFUNCTION
