/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#define INFINITY_SYMBOL Chr(236)

////////////////
////////////////
//
// Purpose:
//    Attempts to lock a record within a specified time
//
// Syntax:
//    fLockRec([<nTime>]) -> lSuccess
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    nTime       Seconds to try for lock [3600]
//
// Returns:
//    lSuccess    .y. if successful
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       CreateTest()
//       CLOSE Test
//
//       fShare("Test")
//       ? fLockRec()         /* .y. */
//       CLOSE Test
//    ENDFUNCTION
//
//    #include "alias.ch"
//    STATIC FUNCTION CreateTest()
//       fCreateDbf("Test/Name/C/32/Balance/N/12/2/Date/D/Over21/L/Notes/M")
//       USE Test NEW EXCLUSIVE
//       ADDRECORD ALIAS Test
//       Test->Name    := "Abbott, Jake"
//       Test->Balance := 0.00
//       Test->Date    := CtoD("9/26/94")
//       Test->Over21  := .y.
//       Test->Notes   := ""
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, John Wm"
//       Test->Balance := 15000.00
//       Test->Date    := CtoD("9/26/94")
//       Test->Over21  := .y.
//       Test->Notes   := "These are notes!"
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, Elizabeth Anne"
//       Test->Balance := 0.58
//       Test->Date    := CtoD("12/18/96")
//       Test->Over21  := .n.
//       Test->Notes   := ""
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, Joseph Alan"
//       Test->Balance := 1.68
//       Test->Date    := CtoD("6/10/98")
//       Test->Over21  := .n.
//       Test->Notes   := "These are too!"
//       ADDRECORD ALIAS Test
//       Test->Name    := "Zumundi, Beavis"
//       Test->Balance := 123.45
//       Test->Date    := CtoD("")
//       Test->Over21  := .y.
//       Test->Notes   := ""
//       GO TOP
//    ENDFUNCTION

//
// Files:
//    (current database file)
//
// Description:
//    Attempts to lock the current record.  If the lock is successful, .true.
//    is returned.  If <nTime> is specified, then the lock attempt will only
//    be attempted for that number of seconds, which defaults to 3 minutes.
//    During the attempt, an infinity symbol is displayed at the lower right-
//    hand portion of the screen.
//
// See Also:
//    fLockFile()
//    LOCK
//    UNLOCK
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fLockRec(nSeconds)
   LOCAL cSaveChar
   DEFAULT nSeconds TO 3600
   cSaveChar := vSave(MaxRow(), MaxCol(), MaxRow(), MaxCol())
   vCursSave()
   @ MaxRow(), MaxCol() SAY INFINITY_SYMBOL
   IF rLock()
      vRestore(cSaveChar)
      vCursRest()
      RETURN .y.
   ENDIF
   tElapsedS()
   WHILE LOOPING
      IF rLock()
         vRestore(cSaveChar)
         vCursRest()
         tElapsedO()
         RETURN .y.
      ENDIF
      IF tElapsedC()>nSeconds
         EXIT
      ENDIF
      vMessageOn({"Attempting to lock record #"+lTrim(Str(RecNo())),;
            "in file "+Alias(), "Record is in use"})
      inkey(.3)
      vMessageOff()
   ENDWHILE
   vRestore(cSaveChar)
   vCursRest()
   tElapsedO()
   RETURN .n.
ENDFUNCTION
