/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Erases (deletes) files by wildcard in specified path
//
// Syntax:
//    fKill(<cWild>, [<cPath>]) -> NIL
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    cWild       DOS wild card file specification
//    cPath       Valid DOS path name where files reside [""]
//
// Returns:
//    NIL
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       fClose(fCreate("testtest.tst"))  /* create test file */
//       fKill("*.tst")
//       ? File("testtest.tst")           /* .f. */
//    ENDFUNCTION
//
// Files:
//    (<cWild>)
//
// Description:
//    Erases the files specified in <cWild>, which is a valid DOS wild card
//    file specification.  An optional path name may be specified, which
//    defaults to the current directory.
//
// See Also:
//    fEraseFiles()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fKill(cWildCard, cPathName)
   DEFAULT cPathName TO ""
   iif(!Empty(cPathName) .and. !Right(cPathName)$':\', cPathName += '\',)
   aEval(Directory(cPathName+cWildCard), {|aFile|fErase(cPathName+aFile[1])})
ENDFUNCTION
