/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns a file name with a new extension
//
// Syntax:
//    fExtNew(<cOldName>, [<cExt>]) -> cNewName
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    cOldName    Old file name
//    cExt        New extension [""]
//
// Returns:
//    cNewName    New file name
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL cTest1 := "Test", cTest2 := "Test.dbf"
//       ? fExtNew(cTest1)             /* "Test."     */
//       ? fExtNew(cTest2)             /* "Test."     */
//       ? fExtNew(cTest1, "frm")      /* "Test.frm"  */
//       ? fExtNew(cTest2, "frm")      /* "Test.frm"  */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns a string containing a file name with a new extension.  The
//    default new extension is blanks.
//
// See Also:
//    fExtension()
//    fExtNone()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fExtNew(cFileName, cExtension)
   LOCAL cNewName
   DEFAULT cExtension TO ""
   IF fExtension(cFileName)
      cNewName := Left(cFileName, Rat(".", cFileName)-1)
   ELSE
      cNewName := cFileName
   ENDIF
   RETURN cNewName+"."+cExtension
ENDFUNCTION
