/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns .true. if the file name has a non-blank extension
//
// Syntax:
//    fExtension([<cFile>]) -> lExtension
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cFile       File name
//
// Returns:
//    lExtension  .y. if a non-blank extension
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL cTest := "Test.dbf"
//       ? fExtension(cTest)        /* .t. */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns .true. if a non-blank extension is found in <cFile>.  If no
//    parameter is passed, then this function returns .false. .
//
// See Also:
//    fExtNone()
//    fExtNew()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fExtension(cFileName)
   IF pCount()!=1
      RETURN .n.
   ENDIF
   cFileName := Trim(cFileName)
   IF !'.'$cFileName
      RETURN .n.
   ELSEIF '\'$cFileName
      IF rAt('\', cFileName)>rAt('.', cFileName)
         RETURN .n.
      ENDIF
   ELSEIF rAt('.', cFileName)+4<=Len(cFileName)
      RETURN .n.
   ENDIF
   RETURN .y.
ENDFUNCTION
