/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns .true. if the drive is a valid logical drive
//
// Syntax:
//    fDriveReady(<cDrive>) -> lValid
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cDrive      Drive letter to check
//
// Returns:
//    lValid      .y. if the drive exists
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       ? fDriveReady("C")      /* .y. if C: is a valid drive */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns .true. if the specified drive is a valid logical drive.
//    <cDrive> may be specified with or without a colon.
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fDriveReady(cDrive)
   LOCAL nHandle
   cDrive += iif(Len(cDrive)=1, ":", "")
   nHandle := fOpen(cDrive+"\NUL")
   IF nHandle<0
      RETURN .n.
   ENDIF
   fClose(nHandle)
   RETURN .y.
ENDFUNCTION
