/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the number of clusters on a drive
//
// Syntax:
//    fClustersND([<cDrive>]) -> nClusters
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cDrive      Drive letter [current drive]
//
// Returns:
//    nClusters   Number of clusters
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       ? fClusters()     /* result varies depending on your drive */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the number of clusters on a specified or the current drive.
//
// See Also:
//    fSectorsNC()
//    fBytesNS()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fClustersND(cDrive)
   IF cDrive=NIL .or. Empty(cDrive)
      RETURN afClusters(0)
   ENDIF
   RETURN afClusters(iDriveNum(cDrive))
ENDFUNCTION
