/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the date in a word format
//
// Syntax:
//    dWord([<dAny>]) -> dString
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dAny        Any date
//
// Returns:
//    dString     Date in a word format
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest := CtoD("9/26/94")
//       ? dWord(dTest)    /* "September 26, 1994" */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the date in a word format, ie "Month Day, Year".
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dWord(dDate)
   IF pCount()=0 .or. dDate=dEmpty()
      RETURN ""
   ENDIF
   RETURN cMonth(dDate)+' '+lTrim(Str(Day(dDate)))+', '+Str(Year(dDate),4)
ENDFUNCTION
