/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Sets the system (DOS) date
//
// Syntax:
//    dSetDate(<cdDate>) -> NIL
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cdDate      Date in either character format or date variable
//
// Returns:
//    NIL
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL cDate := "9/26/95", dDate := CtoD(cDate)
//       // either of these would work the same:
//       dSetDate(cDate)
//       dSetDate(dDate)
//    ENDFUNCTION
//
// Files:
//    Command.com
//
// Description:
//    Uses RUN command to set the system (DOS) date.  <cdDate> may be a string
//    or a date expression, but should not be an empty date or string.
//
// See Also:
//    dSetSysDate()
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dSetDate(cdDate)
   LOCAL cParm
   IF ValType(cdDate)="D"
      cParm := "DATE "+DtoC(cdDate)
      RUN &(cParm)
   ELSE
      cParm := "DATE "+cdDate
      RUN &(cParm)
   ENDIF
ENDFUNCTION
