/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns or sets the SET CENTURY value
//
// Syntax:
//    dSetCentury([<lOnOff>]) -> lSetCentury
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    lOnOff      .y. to turn on SET CENTURY, .n. to turn off, NIL to do
//                nothing [NIL]
//
// Returns:
//    lSetCentury
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       SET CENTURY ON
//       ? dSetCentury()         /* .t. */
//       dSetCentury(.n.)        /* turns off SET CENTURY */
//       ? dSetCentury()         /* .f. */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the current SET CENTURY value, either .y. or .n., and sets it
//    if <lOnOff> is passed.
//
// See Also:
//    Set()
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dSetCentury(lSetIt)
   LOCAL lReturn
   lReturn := Len(CtoD(""))=10
   IF lSetIt!=NIL
      IF lSetIt
         SET CENTURY ON
      ELSE
         SET CENTURY OFF
      ENDIF
   ENDIF
   RETURN lReturn
ENDFUNCTION
