/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the number of months between two dates
//
// Syntax:
//    dNumMonths(<d1>, <d2>) -> nMonths
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    d1          First date
//    d2          Second date
//
// Returns:
//    nMonths     Number of months separating the dates
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest1 := CtoD("1.1.96"), dTest2 := CtoD("2.5.96")
//       ? dNumMonths(dTest1, dTest2)     /* 1 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the number of months between the two dates, where <d2> must be
//    later than <d1>.  The actual algorithm is to find the number of 30-day
//    periods between the 2 dates using the dDays30() function, then dividing
//    by 30 and rounding to the integer position.
//
// See Also:
//    dDays30()
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dNumMonths(d1, d2)
   RETURN Round(dDays30(d1, d2)/30, 0)
ENDFUNCTION
