/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#include "set.ch"

////////////////
////////////////
//
// Purpose:
//    Returns .true. if date or date range is in a leap year
//
// Syntax:
//    dLeapYear([<dTest1>], [<dTest2>]) -> lLeapYear
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    dTest1      either date to test or start of date range [Date()]
//    dTest2      end of date range [NIL]
//
// Returns:
//    lLeapYear   .true. if dTest1 is in a leap year or if range contains a
//                leap day
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest1 := CtoD("1.1.94")
//       LOCAL dTest2 := CtoD("1.1.96")
//       LOCAL dTest3 := CtoD("1.1.98")
//       ? dLeapYear(dTest1)              /* False */
//       ? dLeapYear(dTest2)              /* True  */
//       ? dLeapYear(dTest1, dTest3)      /* True  */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    If the second date is not specified, then the specified date, which
//    defaults to Date(), is checked to see if it is in the same year as a
//    leap day (February 29), returning .true. if it is.  If the second date
//    is specified, then this function will return true if a leap day exists
//    in a year contained within the two dates.
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dLeapYear(dDate, dDate2)
   LOCAL nCtr
   DEFAULT dDate TO Date()
   IF dDate2!=NIL
      FOR nCtr := Year(dDate) TO Year(dDate2)
         IF !Empty(CtoD('2.29.'+Str(nCtr-Set(_SET_EPOCH), 2)))
            RETURN .y.
         ENDIF
      NEXT
      RETURN .n.
   ENDIF
   IF !Empty(CtoD('2.29.'+Str(Year(dDate)-Set(_SET_EPOCH), 2)))
      RETURN .y.
   ENDIF
   RETURN .n.
ENDFUNCTION
