/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the day as a string, ie 1 will return "1st"
//
// Syntax:
//    dDay2Str(<nDay>) -> cDay
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    nDay        Day of month, 1-31
//
// Returns:
//    cDay        Stringified day
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL nDay1 := 1, nDay2 := 30, nDay3 := 99
//       ? dDay2Str()         /* "noparm" */
//       ? dDay2Str(nDay1)    /* "1st"    */
//       ? dDay2Str(nDay2)    /* "30th"   */
//       ? dDay2Str(nDay3)    /* "error"  */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns a stringified version of the day specified in <nDay>.  If no
//    day is passed, then "noparm" is returned.  If the day is outside of the
//    range {1,31}, then "error is returned".  The following table shows the
//    return values:
//
//    Parameter   Returned    Parameter   Returned    Parameter   Returned
//    ---------   --------    ---------   --------    ---------   --------
//    NIL         "noparm"    10          "10th"      21          "21st"
//    <1 or >31   "error"     11          "11th"      22          "22nd"
//    1           "1st"       12          "12th"      23          "23rd"
//    2           "2nd"       13          "13th"      24          "24th"
//    3           "3rd"       14          "14th"      25          "25th"
//    4           "4th"       15          "15th"      26          "26th"
//    5           "5th"       16          "16th"      27          "27th"
//    6           "6th"       17          "17th"      28          "28th"
//    7           "7th"       18          "18th"      29          "29th"
//    8           "8th"       19          "19th"      30          "30th"
//    9           "9th"       20          "20th"      31          "31st"
//
// See Also:
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dDay2Str(nDay)
   IF nDay=NIL
      RETURN 'noparm'
   ENDIF
   RETURN iif(nDay<1 .or. nDay>31, 'error',;
         ltrim(str(nDay,2))+iif(nDay=1 .or. nDay=21 .or. nDay=31, 'st',;
         iif(nDay=2 .or. nDay=22, 'nd', iif(nDay=3 .or. nDay=23, 'rd', 'th'))))
ENDFUNCTION
