/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/


#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the date of the beginning of the month
//
// Syntax:
//    dBegMonth([<dTest>]) -> dBeginning
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dTest       Any date
//
// Returns:
//    dBeginning  First date in month in which dTest is in
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dAny := CtoD("9/26/98")
//       ? dBegMonth(dAny)             /* 09/01/98 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the first date of the month specified in <dTest>.
//
// See Also:
//    dEndMonth()
//    dBegQuarter()
//    dEndQuarter()
//    dDaysLeftM()
//    dDaysGoneM()
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dBegMonth(dCurrent)
   DEFAULT dCurrent TO Date()
   RETURN dCurrent-Day(dCurrent)+1
ENDFUNCTION
