/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/


#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the number of days remaining in a quarter
//
// Syntax:
//    dDaysLeft([<dTest>]) -> nNumDays
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dTest       Date to test [Date()]
//
// Returns:
//    nNumDays    Number of days remaining in the quarter
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest1 := CtoD("12/25/96")
//       LOCAL dTest2 := CtoD("12/31/96")
//       ? dDaysLeftQ(dTest1)                /* 6 */
//       ? dDaysLeftQ(dTest2)                /* 0 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Subtracts the specified date, which defaults to Date(), from the last
//    date in the quarter within which <dTest> falls, returning the number of
//    days until the last date in the quarter.
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dDaysLeftQ(dDate)
   DEFAULT dDate TO Date()
   RETURN dEndQuarter(dDate)-dDate
ENDFUNCTION
